/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.module.shared.jdk21.test;

import com.ovopark.kernel.shared.DBOpeException;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.vfile.DefaultLemonEngine;
import com.ovopark.kernel.shared.vfile.LemonEngine;
import java.lang.invoke.CallSite;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PL {
    private static final Logger log = LoggerFactory.getLogger(PL.class);

    static int next(int min, int max) {
        int f;
        while ((f = new Random().nextInt(max)) <= min) {
        }
        return f;
    }

    public static void main(String[] args) throws Exception {
        String filePath = "D:\\iohub\\test\\psc-lemon";
        DefaultLemonEngine lemonEngine = new DefaultLemonEngine(filePath);
        for (int i = 0; i < 1; ++i) {
            long start = System.currentTimeMillis();
            AtomicInteger c = new AtomicInteger(0);
            lemonEngine.search((a, b) -> c.incrementAndGet());
            log.info("search(): " + c.get() + ", cost: " + Util.costTime((long)start));
            start = System.currentTimeMillis();
        }
        try {
            PL.doConcurrency((LemonEngine)lemonEngine, 10000, 3000, 1000, false, false);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        ArrayList<CompletableFuture<Void>> futureList = new ArrayList<CompletableFuture<Void>>();
        int threadN = 2;
        ExecutorService executorService = Executors.newFixedThreadPool(threadN);
        for (int i = 3000; i > 0; --i) {
            int min = 10000;
            int max = 30000;
            CompletableFuture<Void> future = CompletableFuture.runAsync(Util.catchRunnable((Util.CatchRunnable)new Util.CatchRunnable(){
                final /* synthetic */ LemonEngine val$lemonEngine;
                final /* synthetic */ int val$min;
                final /* synthetic */ int val$max;
                final /* synthetic */ int val$threadN;
                {
                    this.val$lemonEngine = lemonEngine;
                    this.val$min = n;
                    this.val$max = n2;
                    this.val$threadN = n3;
                }

                public void run() throws Exception {
                    TimeUnit.SECONDS.sleep(new Random().nextInt(5));
                    PL.doConcurrency(this.val$lemonEngine, PL.next(this.val$min, this.val$max), new Random().nextInt(this.val$max), new Random().nextInt(this.val$max), false, this.val$threadN > 1);
                }
            }), executorService);
            futureList.add(future);
        }
        CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).get();
        log.info("ok , all task completed: " + futureList.size());
        lemonEngine.close();
        TimeUnit.SECONDS.sleep(3600L);
    }

    private static int search(final LemonEngine lemonEngine, final boolean print, final Check check, final boolean concurrency, Set<String> deletedKeySet) {
        final AtomicLong key = new AtomicLong();
        long start = System.currentTimeMillis();
        int maxNum = 9990000;
        final AtomicInteger sum = new AtomicInteger();
        final AtomicReference pre = new AtomicReference();
        final LinkedHashMap allMap = new LinkedHashMap();
        lemonEngine.search(new LemonEngine.SearchListener(){

            public void onRow(LemonEngine.GetResult fileGetResult, LemonEngine.SearchContext searchContext) {
                sum.incrementAndGet();
                if (sum.get() > 9990000) {
                    searchContext.cancel();
                }
                String seq = fileGetResult.key();
                LemonEngine.GetResult fileGetResult1 = lemonEngine.get(seq);
                if (!(concurrency || fileGetResult1 != null && fileGetResult1.vcc() == fileGetResult.vcc())) {
                    log.error("error: " + fileGetResult.vcc() + "," + fileGetResult.exists() + ", get: " + fileGetResult1.vcc() + ", ");
                }
                if (allMap.containsKey(seq)) {
                    LemonEngine.GetResult b = (LemonEngine.GetResult)allMap.get(seq);
                    for (int i = 0; i < 100; ++i) {
                        fileGetResult1 = lemonEngine.get(seq);
                        log.info(fileGetResult1 == null ? null : fileGetResult1.toString());
                    }
                    log.info("duplicate " + seq + " > " + b.vcc() + "," + b.exists() + ", after: " + fileGetResult.vcc() + ", " + fileGetResult.exists());
                }
                allMap.put(seq, fileGetResult);
                if (print) {
                    Map map = fileGetResult.value();
                    log.info(seq + " > " + JSONAccessor.impl().format((Object)map));
                }
                if (!check.valid(key.get(), Long.valueOf(seq.split(":")[1]), fileGetResult)) {
                    log.info("-------------------error start --------");
                    log.info((String)pre.get());
                    log.info(fileGetResult.exists() + "," + seq + " > " + JSONAccessor.impl().format((Object)fileGetResult.value()));
                    log.info("-------------------error end--------");
                    throw DBOpeException.from((String)(key.get() + ", ERROR: " + seq));
                }
                key.set(Long.valueOf(seq.split(":")[1]));
                pre.set(fileGetResult.exists() + "," + seq + " > " + JSONAccessor.impl().format((Object)fileGetResult.value()));
            }
        });
        log.info("search() : " + sum.get() + " , cost: " + Util.costTime((long)start));
        start = System.currentTimeMillis();
        int c = lemonEngine.count();
        log.info("count() : " + c + " , cost: " + Util.costTime((long)start));
        log.info("count() , search(), sum: " + sum.get() + " == " + c + ", " + (sum.get() == c));
        start = System.currentTimeMillis();
        int count = 0;
        if (sum.get() > 1000000) {
            List list;
            String deleteKey = null;
            while (!Util.isEmpty((Collection)(list = lemonEngine.searchAfter(deleteKey, false, 100)))) {
                for (LemonEngine.GetResult fileGetResult : list) {
                    deleteKey = fileGetResult.key();
                    lemonEngine.delete(deleteKey);
                    deletedKeySet.add(deleteKey);
                    ++count;
                }
                if (count <= sum.get() / 3) continue;
                break;
            }
        }
        log.info("search sum: " + String.valueOf(sum) + ", delete: " + count + ", cost: " + Util.costTime((long)start));
        return sum.get();
    }

    private static void doConcurrency(LemonEngine lemonEngine, int dataCount, final int deleteCount, final int updateCount, boolean printGet, final boolean concurrency) throws InterruptedException {
        String PREFIX = Util.uniqueFirstPart() + ":";
        log.info("----------------------- doSerial (" + !concurrency + ")(" + PREFIX + ") all start ---------");
        HashSet<String> searchAndDeletedKeySet = new HashSet<String>();
        final HashSet initKeySet = new HashSet();
        int initCount = PL.search(lemonEngine, false, new Check(){

            @Override
            public boolean valid(long b, long a, LemonEngine.GetResult fileGetResult) {
                initKeySet.add(fileGetResult.key());
                return concurrency || deleteCount > 0 || updateCount > 0 || a - b == 1L;
            }
        }, concurrency, searchAndDeletedKeySet);
        log.info("existing data count: " + initCount);
        log.info("ok , begin put");
        LinkedHashMap<String, LemonEngine.PutResult> filePutResultMap = new LinkedHashMap<String, LemonEngine.PutResult>();
        for (int i = 0; i < dataCount; ++i) {
            HashMap<String, CallSite> data = new HashMap<String, CallSite>();
            data.put("desc", (CallSite)((Object)("desc(" + Util.formatTime((LocalDateTime)LocalDateTime.now(), (String[])new String[0]) + "):" + i)));
            LemonEngine.PutResult putResult = lemonEngine.put(PREFIX + i, data);
            filePutResultMap.put(putResult.key(), putResult);
        }
        log.info("put completed: " + dataCount);
        final HashSet countAfterPutKeySet = new HashSet();
        int countAfterPut = PL.search(lemonEngine, false, new Check(){

            @Override
            public boolean valid(long b, long a, LemonEngine.GetResult fileGetResult) {
                countAfterPutKeySet.add(fileGetResult.key());
                return concurrency || deleteCount > 0 || updateCount > 0 || a - b == 1L;
            }
        }, concurrency, searchAndDeletedKeySet);
        HashSet<String> deletedKeySet = new HashSet<String>();
        int delCount = 0;
        for (Map.Entry entry : new HashMap(filePutResultMap).entrySet()) {
            String key = (String)entry.getKey();
            if (lemonEngine.get(key).vcc() < 0L) {
                throw DBOpeException.from((String)"data is missing");
            }
            lemonEngine.delete(key);
            deletedKeySet.add(key);
            if (delCount++ <= deleteCount) continue;
            break;
        }
        for (String d : deletedKeySet) {
            LemonEngine.GetResult fileGetResult = lemonEngine.get(d);
            if (fileGetResult == null || !fileGetResult.exists()) continue;
            throw DBOpeException.from((String)"the key should be deleted???");
        }
        log.info("delete completed: " + delCount);
        log.info("rowCountIncludeInvalidData: " + lemonEngine.count());
        final HashSet countAfterDeleteKeySet = new HashSet();
        int countAfterDelete = PL.search(lemonEngine, false, new Check(){

            @Override
            public boolean valid(long b, long a, LemonEngine.GetResult fileGetResult) {
                countAfterDeleteKeySet.add(fileGetResult.key());
                return concurrency || deleteCount > 0 || updateCount > 0 || a - b > 0L;
            }
        }, concurrency, searchAndDeletedKeySet);
        HashSet<String> updateExistsSet = new HashSet<String>();
        int updateExistCount = 0;
        final AtomicInteger noopCount = new AtomicInteger();
        final AtomicInteger compareAndSetCount = new AtomicInteger();
        for (Map.Entry entry : new HashMap(filePutResultMap).entrySet()) {
            String key = (String)entry.getKey();
            if (deletedKeySet.contains(key)) continue;
            LemonEngine.GetResult fileGetResult = lemonEngine.get(key);
            if (fileGetResult == null) {
                throw DBOpeException.from((String)"the key should exists???");
            }
            HashMap<String, Object> meta = new HashMap<String, Object>();
            meta.put("i", updateExistCount);
            meta.put("name", "update-name(" + Util.formatTime((LocalDateTime)LocalDateTime.now(), (String[])new String[0]) + "):" + updateExistCount);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("desc", "update-desc(" + Util.formatTime((LocalDateTime)LocalDateTime.now(), (String[])new String[0]) + "):" + updateExistCount);
            hashMap.put("updated", key);
            final int next = PL.next(0, 100);
            if (next % 3 == 0) {
                LemonEngine.CompareAndSetResult compareAndSetResult = lemonEngine.compareAndSet(key, new LemonEngine.CompareAndSet(){

                    public LemonEngine.Setter test(LemonEngine.GetResult fileGetResult, LemonEngine.Operator operator) {
                        if (fileGetResult.vcc() % 3L == 0L) {
                            noopCount.incrementAndGet();
                            return operator.noop();
                        }
                        Map map = fileGetResult.value();
                        map.put("compareAndSet", "ok-" + next);
                        compareAndSetCount.incrementAndGet();
                        return operator.update().data(map);
                    }
                });
                if (compareAndSetResult.noop()) continue;
                LemonEngine.GetResult gf = lemonEngine.get(key);
                if (!concurrency && gf.vcc() == compareAndSetResult.updated().vcc() && !gf.value().containsKey("compareAndSet")) {
                    throw DBOpeException.from((String)"error");
                }
                updateExistsSet.add(key);
                if (updateExistCount++ <= updateCount) continue;
                break;
            }
            updateExistsSet.add(key);
            if (updateExistCount++ <= updateCount) continue;
            break;
        }
        log.info("updated-exists completed: " + updateExistCount + ", compareAndSet noop: " + noopCount.get() + ", compareAndSet updated: " + compareAndSetCount.get());
        final HashSet countAfterUpdateExistsKeySet = new HashSet();
        int countAfterUpdateExists = PL.search(lemonEngine, false, new Check(){

            @Override
            public boolean valid(long b, long a, LemonEngine.GetResult fileGetResult) {
                countAfterUpdateExistsKeySet.add(fileGetResult.key());
                return true;
            }
        }, concurrency, searchAndDeletedKeySet);
        HashSet<String> updateDeletedSet = new HashSet<String>();
        int updateDeletedCount = 0;
        for (Map.Entry entry : new HashMap(filePutResultMap).entrySet()) {
            String key = (String)entry.getKey();
            if (!deletedKeySet.contains(key)) continue;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("desc", "update-desc(" + Util.formatTime((LocalDateTime)LocalDateTime.now(), (String[])new String[0]) + "):" + updateDeletedCount);
            data.put("updated-deleted", key);
            lemonEngine.put(key, data);
            updateDeletedSet.add(key);
            if (updateDeletedCount++ <= updateCount) continue;
            break;
        }
        log.info("updated-deleted completed: " + updateDeletedCount + "/ " + updateDeletedSet.size());
        final HashSet countAfterUpdateDeletedKeySet = new HashSet();
        int n = PL.search(lemonEngine, false, new Check(){

            @Override
            public boolean valid(long b, long a, LemonEngine.GetResult fileGetResult) {
                countAfterUpdateDeletedKeySet.add(fileGetResult.key());
                return true;
            }
        }, concurrency, searchAndDeletedKeySet);
        String start = null;
        int i = new Random().nextInt(filePutResultMap.size());
        int ic = 0;
        for (Map.Entry entry : filePutResultMap.entrySet()) {
            if (ic++ <= i) continue;
            start = (String)entry.getKey();
            break;
        }
        LinkedHashMap<String, LemonEngine.GetResult> searchAfterMap = new LinkedHashMap<String, LemonEngine.GetResult>();
        int searchAfterCount = 0;
        for (LemonEngine.GetResult fileGetResult : lemonEngine.searchAfter(start, false, 100)) {
            String seq = fileGetResult.key();
            if (seq.compareTo(start) <= 0) {
                throw DBOpeException.from((String)("searchAfter error: " + (String)seq));
            }
            ++searchAfterCount;
            searchAfterMap.put(seq, fileGetResult);
        }
        log.info("searchAfter( < " + start + ") completed, searchAfter count: " + searchAfterCount + "/ " + searchAfterMap.size());
        LinkedHashMap<String, LemonEngine.GetResult> searchBeforeMap = new LinkedHashMap<String, LemonEngine.GetResult>();
        int searchBeforeCount = 0;
        for (LemonEngine.GetResult fileGetResult : lemonEngine.searchBefore(start, false, 100)) {
            String seq = fileGetResult.key();
            if (seq.compareTo(start) > 0) {
                throw DBOpeException.from((String)("searchBefore error: " + seq + " > " + start));
            }
            ++searchBeforeCount;
            searchBeforeMap.put(seq, fileGetResult);
        }
        log.info("searchBefore( > " + start + ") completed, searchBefore count: " + searchBeforeCount + "/ " + searchBeforeMap.size());
        int tailCount = 0;
        LinkedHashMap<String, LemonEngine.GetResult> tailMap = new LinkedHashMap<String, LemonEngine.GetResult>();
        AtomicReference<LemonEngine.GetResult> last = new AtomicReference<LemonEngine.GetResult>();
        for (LemonEngine.GetResult fileGetResult : lemonEngine.tail(100)) {
            String seq = fileGetResult.key();
            if (tailMap.isEmpty()) {
                tailMap.put(seq, fileGetResult);
                last.set(fileGetResult);
                continue;
            }
            tailMap.put(seq, fileGetResult);
            if (seq.compareTo(((LemonEngine.GetResult)last.get()).key()) > 0) {
                throw DBOpeException.from((String)("tail error: " + (String)seq));
            }
            ++tailCount;
            last.set(fileGetResult);
        }
        log.info("tail completed, tail count: " + tailCount);
        int topCount = 0;
        LinkedHashMap<String, LemonEngine.GetResult> topMap = new LinkedHashMap<String, LemonEngine.GetResult>();
        last = new AtomicReference();
        for (LemonEngine.GetResult fileGetResult : lemonEngine.top(100)) {
            String key = fileGetResult.key();
            if (topMap.isEmpty()) {
                topMap.put(key, fileGetResult);
                last.set(fileGetResult);
                continue;
            }
            topMap.put(key, fileGetResult);
            if (key.compareTo(((LemonEngine.GetResult)last.get()).key()) < 0) {
                throw DBOpeException.from((String)("top error: " + key));
            }
            ++topCount;
            last.set(fileGetResult);
        }
        log.info("top completed, top count: " + topCount);
        log.info("to do search / regex ");
        int regexCount = 0;
        final Pattern pattern = Pattern.compile(".+7.+8.*");
        List regexResultList = lemonEngine.searchAfter(start, false, 100, (Predicate)new Predicate<String>(){

            @Override
            public boolean test(String s) {
                return pattern.matcher(s).matches();
            }
        });
        for (LemonEngine.GetResult fileGetResult : regexResultList) {
            String key = fileGetResult.key();
            if (!pattern.matcher(key).matches()) {
                throw DBOpeException.from((String)("error: " + key));
            }
            ++regexCount;
        }
        log.info("search / regex completed, search / regex count: " + regexCount);
        log.info("to do get");
        int getCount = 0;
        for (String k : filePutResultMap.keySet()) {
            block28: {
                LemonEngine.GetResult fileGetResult = lemonEngine.get(k);
                if (fileGetResult == null) {
                    if (searchAndDeletedKeySet.contains(k)) {
                        ++getCount;
                    }
                    if (!printGet) continue;
                    log.info("get, key deleted?: " + k);
                    continue;
                }
                try {
                    Map map = fileGetResult.value();
                    if (!printGet) break block28;
                    log.info(k + " (" + fileGetResult.vcc() + ")> " + JSONAccessor.impl().format((Object)map));
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    break;
                }
            }
            ++getCount;
        }
        log.info("get completed, get count: " + getCount + "/ " + filePutResultMap.size() + "/ (deleted: " + (filePutResultMap.size() - getCount == delCount - updateDeletedCount) + ", " + (filePutResultMap.size() - getCount) + "==?" + (delCount - updateDeletedCount) + ")");
        assert (filePutResultMap.size() - getCount == delCount - updateDeletedCount);
        log.info("----------------------- doSerial all ok ---------");
    }

    static interface Check {
        public boolean valid(long var1, long var3, LemonEngine.GetResult var5);
    }
}

