/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.module.shared.jdk21.test;

import com.ovopark.kernel.shared.ServiceProvider;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.kv.CacheServiceV2;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class E2 {
    private static final Logger log = LoggerFactory.getLogger(E2.class);
    private static Map<Comparable, Object> longDelay = new ConcurrentHashMap<Comparable, Object>();
    static volatile boolean stopSchedule = false;

    public static void main(String[] args) throws InterruptedException {
        int minute = 3;
        final AtomicLong expiredCount = new AtomicLong();
        final AtomicLong writeCount = new AtomicLong();
        final long start = System.currentTimeMillis();
        final CacheServiceV2 CS = CacheServiceV2.impl();
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        final Random random = new Random();
        int i = 0;
        while (i < 10000) {
            final int j = i++;
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    final int time = random.nextInt(10, 180000);
                    CS.putIfAbsentAndGet((Comparable)((Object)("i-" + j)), (Supplier)new ServiceProvider<String>(){

                        public String get() {
                            writeCount.incrementAndGet();
                            return "expired(ms): " + time;
                        }
                    });
                }
            });
        }
        Executors.newScheduledThreadPool(1).scheduleWithFixedDelay(new Runnable(){
            long temp;

            @Override
            public void run() {
                long c = expiredCount.get();
                log.info("write count: " + writeCount.get() + ", expired: " + c + "(+" + (c - this.temp) + ")");
                this.temp = c;
                final int time = random.nextInt(10, 180000);
                CS.putAndGet((Comparable)((Object)("i-" + Util.uniqueFirstPart() + "-" + time)), (Function)new Function<String, String>(){

                    @Override
                    public String apply(String s) {
                        writeCount.incrementAndGet();
                        return "expired(ms): " + time;
                    }
                });
                if (writeCount.get() > 30000000L || System.currentTimeMillis() - start > 300000L) {
                    stopSchedule = true;
                }
            }
        }, 0L, 3L, TimeUnit.SECONDS);
        TimeUnit.SECONDS.sleep(30000L);
    }
}

