/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.module.shared.jdk21.test;

import com.ovopark.kernel.shared.ServiceProvider;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.kv.TtlCacheServiceV2;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class E1 {
    private static final Logger log = LoggerFactory.getLogger(E1.class);
    private static final Map<Comparable, Object> longDelay = new ConcurrentHashMap<Comparable, Object>();
    static volatile boolean stopSchedule = false;

    public static void main(String[] args) throws InterruptedException {
        int minute = 3;
        final AtomicLong expiredCount = new AtomicLong();
        final AtomicLong writeCount = new AtomicLong();
        final long start = System.currentTimeMillis();
        final TtlCacheServiceV2 CS = TtlCacheServiceV2.impl().subscribeTtl(k -> true, (key, value, startTime, expiredTime) -> {
            LocalDateTime triggerTime = Util.dateTime((long)(startTime + expiredTime));
            LocalDateTime now = LocalDateTime.now();
            long realDelay = now.toInstant(Util.GMT_08).toEpochMilli() - startTime;
            if (realDelay - expiredTime > 1000L) {
                if (longDelay.size() < 10000) {
                    longDelay.put((Comparable)((Object)key), value);
                }
                log.info(key + ",delay(ms):" + expiredTime + "/(" + realDelay + "+" + (realDelay - expiredTime) + "), start: " + Util.formatTime((LocalDateTime)Util.dateTime((long)startTime), (String[])new String[]{"HH:mm:ss.SSS"}) + ", trigger: " + Util.formatTime((LocalDateTime)triggerTime, (String[])new String[]{"HH:mm:ss.SSS"}) + ", now: " + Util.formatTime((LocalDateTime)now, (String[])new String[]{"HH:mm:ss.SSS"}));
            }
            expiredCount.incrementAndGet();
        });
        CS.subscribeTtl(s -> s.startsWith("i-1000"), (TtlCacheServiceV2.TtlListener)new TtlCacheServiceV2.TtlListener<String>(){

            public void onTtl(String key, Object value, long startMilli, long expiredMilli) {
                log.info("match, key: " + key + " value: " + String.valueOf(value));
            }
        });
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        final Random random = new Random();
        int i = 0;
        while (i < 1000000) {
            final int j = i++;
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    final int time = random.nextInt(10, 180000);
                    CS.putIfAbsentAndGet((Comparable)((Object)("i-" + j)), (Supplier)new ServiceProvider<String>(){

                        public String get() {
                            writeCount.incrementAndGet();
                            return "expired(ms): " + time;
                        }
                    }, (long)time, TimeUnit.MILLISECONDS);
                }
            });
        }
        for (i = 0; i < Runtime.getRuntime().availableProcessors(); ++i) {
            Executors.newScheduledThreadPool(1).scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    if (stopSchedule) {
                        return;
                    }
                    for (int i1 = 0; i1 < 100; ++i1) {
                        final int time = random.nextInt(10, 180000);
                        CS.putIfAbsentAndGet((Comparable)((Object)("i-" + Util.uniqueFirstPart() + "-" + time)), (Supplier)new ServiceProvider<String>(){

                            public String get() {
                                writeCount.incrementAndGet();
                                return "expired(ms): " + time;
                            }
                        }, (long)time, TimeUnit.MILLISECONDS);
                    }
                }
            }, 0L, 30L, TimeUnit.MILLISECONDS);
        }
        for (i = 0; i < Runtime.getRuntime().availableProcessors(); ++i) {
            Executors.newScheduledThreadPool(1).scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    if (stopSchedule) {
                        return;
                    }
                    for (int i1 = 0; i1 < 100; ++i1) {
                        final int time = random.nextInt(10, 180000);
                        CS.putAndGet((Comparable)((Object)("i-" + Util.uniqueFirstPart() + "-" + time)), (Function)new Function<String, String>(){

                            @Override
                            public String apply(String s) {
                                if (Util.isEmpty((CharSequence)s)) {
                                    writeCount.incrementAndGet();
                                }
                                return "expired(ms): " + time;
                            }
                        }, (long)time, TimeUnit.MILLISECONDS);
                    }
                }
            }, 0L, 30L, TimeUnit.MILLISECONDS);
        }
        for (i = 0; i < Runtime.getRuntime().availableProcessors(); ++i) {
            Executors.newScheduledThreadPool(1).scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    if (stopSchedule) {
                        return;
                    }
                    for (int i1 = 0; i1 < 100; ++i1) {
                        final int time = random.nextInt(10, 180000);
                        CS.putAndGet((Comparable)((Object)("i-" + Util.uniqueFirstPart() + "-" + time)), (Function)new Function<String, String>(){

                            @Override
                            public String apply(String s) {
                                return "expired(ms): " + time;
                            }
                        }, (long)time, TimeUnit.MILLISECONDS);
                    }
                }
            }, 0L, 30L, TimeUnit.MILLISECONDS);
        }
        Executors.newScheduledThreadPool(1).scheduleWithFixedDelay(new Runnable(){
            long temp;

            @Override
            public void run() {
                long c = expiredCount.get();
                log.info("write count: " + writeCount.get() + ", expired: " + c + "(+" + (c - this.temp) + ")");
                this.temp = c;
                final int time = random.nextInt(10, 180000);
                CS.putIfAbsentAndGet((Comparable)((Object)("i-" + Util.uniqueFirstPart() + "-" + time)), (Supplier)new ServiceProvider<String>(){

                    public String get() {
                        writeCount.incrementAndGet();
                        return "expired(ms): " + time;
                    }
                }, (long)time, TimeUnit.MILLISECONDS);
                if (writeCount.get() > 30000000L || System.currentTimeMillis() - start > 300000L) {
                    stopSchedule = true;
                }
            }
        }, 0L, 3L, TimeUnit.SECONDS);
        TimeUnit.SECONDS.sleep(30000L);
    }
}

