/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.module.shared.jdk21.test;

import com.ovopark.kernel.shared.DBOpeException;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.concurrent.ReleasableLock;
import com.ovopark.kernel.shared.vfile.DefaultLemonEngine;
import com.ovopark.kernel.shared.vfile.LemonEngine;
import com.ovopark.kernel.shared.vfile.Tests;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PL {
    private static final Logger log = LoggerFactory.getLogger(PL.class);
    private static final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private static final ReleasableLock sLock = new ReleasableLock((Lock)readWriteLock.readLock());
    private static final ReleasableLock xLock = new ReleasableLock((Lock)readWriteLock.writeLock());
    private static final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, Util.newThreadFactory((String)"truncate"));
    private static final AtomicInteger keySeq = new AtomicInteger();

    static int next(int min, int max) {
        int f;
        while ((f = new Random().nextInt(max)) <= min) {
        }
        return f;
    }

    public static void main(String[] args) throws Exception {
        String filePath = "D:\\iohub\\test\\psc-lemon";
        DefaultLemonEngine.Conf conf = new DefaultLemonEngine.Conf();
        conf.setMemoryBufferSizeMb(1000L);
        conf.setSparseIfMinCount(10000000);
        conf.setWalBufferSizeMb(1);
        conf.setWalDiskSizeMb(3L);
        DefaultLemonEngine lemonEngine = new DefaultLemonEngine(filePath, conf);
        LemonEngine.mgr().add("pl", (LemonEngine)lemonEngine);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.out);
        lemonEngine.pretty(outputStreamWriter);
        outputStreamWriter.flush();
        System.out.println("\r\n");
        for (int i = 0; i < 1; ++i) {
            long start = System.currentTimeMillis();
            AtomicInteger c = new AtomicInteger(0);
            lemonEngine.search((a, b) -> c.incrementAndGet());
            log.info("search(): " + c.get() + ", cost: " + Util.costTime((long)start));
            start = System.currentTimeMillis();
        }
        long start = System.currentTimeMillis();
        lemonEngine.merge();
        log.info("merge completed, cost: " + Util.costTime((long)start));
        outputStreamWriter = new OutputStreamWriter(System.out);
        lemonEngine.pretty(outputStreamWriter);
        outputStreamWriter.flush();
        System.out.println("\r\n");
        try {
            int count = 0;
            String scanKey = null;
            block5: while (true) {
                long startTime = System.currentTimeMillis();
                List list = lemonEngine.searchAfter(scanKey, false, 1000);
                log.info("already scan count: " + count + " , searchAfter (" + scanKey + ") cost: " + Util.costTime((long)startTime));
                if (!Util.isEmpty((Collection)list)) {
                    Iterator iterator = list.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block5;
                        LemonEngine.GetResult fileGetResult = (LemonEngine.GetResult)iterator.next();
                        scanKey = fileGetResult.key();
                        ++count;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        PL.snapshot((LemonEngine)lemonEngine);
        try {
            PL.doConcurrency((LemonEngine)lemonEngine, 10000, 3000, 1000, false, false, -1);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        Util.schedule((ScheduledExecutorService)scheduledExecutorService, (Util.CatchRunnable)new Util.CatchRunnable((LemonEngine)lemonEngine){
            final /* synthetic */ LemonEngine val$lemonEngine;
            {
                this.val$lemonEngine = lemonEngine;
            }

            public void run() throws Exception {
                PL.truncate(this.val$lemonEngine);
            }
        }, (long)15L, (TimeUnit)TimeUnit.SECONDS, t -> true, () -> true);
        Util.schedule((ScheduledExecutorService)scheduledExecutorService, (Util.CatchRunnable)new Util.CatchRunnable((LemonEngine)lemonEngine){
            final /* synthetic */ LemonEngine val$lemonEngine;
            {
                this.val$lemonEngine = lemonEngine;
            }

            public void run() throws Exception {
                PL.snapshot(this.val$lemonEngine);
            }
        }, (long)3L, (TimeUnit)TimeUnit.SECONDS, t -> true, () -> true);
        ArrayList<CompletableFuture<Void>> futureList = new ArrayList<CompletableFuture<Void>>();
        int threadN = 5;
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        int i = 9000;
        while (i > 0) {
            int min = 10000;
            int max = 30000;
            int finalI = i--;
            CompletableFuture<Void> future = CompletableFuture.runAsync(Util.catchRunnable((Util.CatchRunnable)new Util.CatchRunnable(){
                final /* synthetic */ LemonEngine val$lemonEngine;
                final /* synthetic */ int val$min;
                final /* synthetic */ int val$max;
                final /* synthetic */ int val$finalI;
                {
                    this.val$lemonEngine = lemonEngine;
                    this.val$min = n;
                    this.val$max = n2;
                    this.val$finalI = n3;
                }

                public void run() throws Exception {
                    TimeUnit.SECONDS.sleep(new Random().nextInt(5));
                    PL.s_lock(new DoInLock<Void>(){

                        @Override
                        public Void doInLock() {
                            try {
                                PL.doConcurrency(val$lemonEngine, PL.next(val$min, val$max), new Random().nextInt(val$max), new Random().nextInt(val$max), false, true, val$finalI);
                            }
                            catch (Exception e) {
                                log.error(e.getMessage(), (Throwable)e);
                                throw new RuntimeException(e);
                            }
                            return null;
                        }
                    }, Integer.MAX_VALUE, TimeUnit.SECONDS);
                }
            }), executorService);
            futureList.add(future);
        }
        CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).get();
        log.info("ok , all task completed: " + futureList.size());
        lemonEngine.close();
        TimeUnit.SECONDS.sleep(3600L);
    }

    private static void redirectSystemIoOut() {
        try {
            String timestamp = new SimpleDateFormat("yyyy-MM-dd-HHmmss").format(new Date());
            String logFileName = "D:\\iohub\\test\\log\\pl.log-" + timestamp + ".log";
            PrintStream out = new PrintStream(new FileOutputStream(logFileName));
            System.setOut(out);
            System.setErr(out);
            System.out.println("\u793a\u4f8b\u8f93\u51fa ,\u8fd9\u662f\u63a7\u5236\u53f0\u8f93\u51fa\u5185\u5bb9");
            System.err.println("\u793a\u4f8b\u8f93\u51fa ,\u8fd9\u662f\u4e00\u4e2a\u9519\u8bef\u4fe1\u606f");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("\u7a0b\u5e8f\u7ee7\u7eed\u8fd0\u884c...");
    }

    private static int search(final LemonEngine lemonEngine, boolean concurrency, final Map<String, LemonEngine.PutResult> filePutResultMap, final Map<String, LemonEngine.DeleteResult> deletedResultMap, final String PREFIX) {
        long start = System.currentTimeMillis();
        final AtomicInteger sum = new AtomicInteger();
        final HashMap allMap = new HashMap();
        final AtomicInteger foundCount = new AtomicInteger();
        final HashSet foundSet = new HashSet();
        lemonEngine.search(new LemonEngine.SearchListener(){

            public void onRow(LemonEngine.GetResult getResult, LemonEngine.SearchContext searchContext) {
                sum.incrementAndGet();
                String key = getResult.key();
                if (Util.isEmpty((CharSequence)PREFIX) || !key.startsWith(PREFIX)) {
                    return;
                }
                LemonEngine.GetResult result = lemonEngine.get(key);
                if (result == null || result.vcc() != getResult.vcc()) {
                    throw DBOpeException.from((String)("error: " + getResult.vcc() + "," + getResult.exists() + ", get: " + result.vcc() + ", "));
                }
                if (allMap.containsKey(key)) {
                    LemonEngine.GetResult b = (LemonEngine.GetResult)allMap.get(key);
                    throw DBOpeException.from((String)("duplicate " + key + " > " + b.vcc() + "," + b.exists() + ", after: " + getResult.vcc() + ", " + getResult.exists()));
                }
                allMap.put(key, getResult);
                if (deletedResultMap.containsKey(key)) {
                    throw DBOpeException.from((String)("the key should be deleted: " + key));
                }
                if (filePutResultMap.containsKey(key)) {
                    foundCount.incrementAndGet();
                    foundSet.add(key);
                }
            }
        });
        if (foundCount.get() != filePutResultMap.size() - deletedResultMap.size()) {
            HashSet<String> restSet = new HashSet<String>(filePutResultMap.keySet());
            restSet.removeAll(foundSet);
            List<String> list = new HashSet<String>(restSet).stream().filter(v -> !deletedResultMap.containsKey(v)).toList();
            for (String k : list) {
                LemonEngine.GetResult getResult = lemonEngine.get(k);
                log.info("recheck: " + getResult.exists());
                if (!getResult.exists()) continue;
                log.info("recheck: " + getResult.exists() + ", " + JSONAccessor.impl().format((Object)getResult.value()));
            }
            throw DBOpeException.from((String)(" data count does not match: " + foundCount.get() + " / " + (filePutResultMap.size() - deletedResultMap.size()) + ", filePutResultMap size: " + filePutResultMap.size() + ", deletedResultMap size: " + deletedResultMap.size()));
        }
        log.info("search check result () : " + sum.get() + " / " + lemonEngine.count() + " , cost: " + Util.costTime((long)start) + ", foundCount-check: " + foundCount.get() + " / " + (filePutResultMap.size() - deletedResultMap.size()) + ", filePutResultMap size: " + filePutResultMap.size() + ", deletedResultMap size: " + deletedResultMap.size());
        start = System.currentTimeMillis();
        int c = lemonEngine.count();
        log.info("count() : " + c + " , cost: " + Util.costTime((long)start));
        return sum.get();
    }

    /*
     * WARNING - void declaration
     */
    private static void doConcurrency(LemonEngine lemonEngine, int dataCount, int deleteCount, int updateCount, boolean printGet, boolean concurrency, int taskIndex) throws Exception {
        void var19_30;
        void var15_24;
        String PREFIX = Util.uniqueFirstPart() + "_" + keySeq.incrementAndGet() + ":";
        long allStart = System.currentTimeMillis();
        log.info("----------------------- doSerial ( " + taskIndex + " ) (" + !concurrency + ")(" + PREFIX + ") all start ---------");
        int initCount = PL.search(lemonEngine, concurrency, new HashMap<String, LemonEngine.PutResult>(), new HashMap<String, LemonEngine.DeleteResult>(), null);
        log.info("existing data count: " + initCount);
        log.info("ok , begin put");
        LinkedHashMap<String, LemonEngine.PutResult> filePutResultMap = new LinkedHashMap<String, LemonEngine.PutResult>();
        for (int i = 0; i < dataCount; ++i) {
            HashMap<String, CallSite> data = new HashMap<String, CallSite>();
            data.put("desc", (CallSite)((Object)("desc(" + Util.formatTime((LocalDateTime)LocalDateTime.now(), (String[])new String[0]) + "):" + i)));
            Iterator key = PREFIX + i;
            if (i % 100 == 0) {
                LemonEngine.PutResult putResult = lemonEngine.append((String)((Object)key), data);
                if (putResult.created()) {
                    filePutResultMap.put(putResult.key(), putResult);
                    continue;
                }
                throw DBOpeException.from((String)("put error: " + (String)((Object)key)));
            }
            LemonEngine.PutResult putResult = lemonEngine.put((String)((Object)key), data);
            if (putResult.created()) {
                filePutResultMap.put(putResult.key(), putResult);
                continue;
            }
            throw DBOpeException.from((String)("put error: " + (String)((Object)key)));
        }
        log.info("put completed: " + dataCount);
        PL.search(lemonEngine, concurrency, filePutResultMap, new HashMap<String, LemonEngine.DeleteResult>(), PREFIX);
        HashMap<String, LemonEngine.DeleteResult> realDeletedKeySet = new HashMap<String, LemonEngine.DeleteResult>();
        int selfDelCount = 0;
        for (Map.Entry entry : new HashMap<String, LemonEngine.PutResult>(filePutResultMap).entrySet()) {
            String key = (String)entry.getKey();
            LemonEngine.GetResult getResult = lemonEngine.get(key);
            if (!getResult.exists()) {
                throw DBOpeException.from((String)("the key is missing: " + key));
            }
            LemonEngine.DeleteResult deleteResult = lemonEngine.delete(key);
            if (!deleteResult.deleted()) continue;
            realDeletedKeySet.put(key, deleteResult);
            if (selfDelCount++ <= deleteCount) continue;
            break;
        }
        for (String string : realDeletedKeySet.keySet()) {
            LemonEngine.GetResult fileGetResult = lemonEngine.get(string);
            if (fileGetResult == null || !fileGetResult.exists()) continue;
            throw DBOpeException.from((String)("the key should be deleted???: " + string));
        }
        log.info("delete completed: " + selfDelCount);
        log.info("row count, after delete: " + lemonEngine.count());
        PL.search(lemonEngine, concurrency, filePutResultMap, realDeletedKeySet, PREFIX);
        HashSet<Object> updateExistsSet = new HashSet<Object>();
        boolean bl = false;
        final AtomicInteger noopCount = new AtomicInteger();
        final AtomicInteger compareAndSetCount = new AtomicInteger();
        for (Map.Entry entry : new HashMap<String, LemonEngine.PutResult>(filePutResultMap).entrySet()) {
            String key = (String)entry.getKey();
            if (realDeletedKeySet.containsKey(key)) continue;
            LemonEngine.GetResult getResult = lemonEngine.get(key);
            if (getResult == null || !getResult.exists()) {
                throw DBOpeException.from((String)"the key should exists???");
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("desc", "update-desc(" + Util.formatTime((LocalDateTime)LocalDateTime.now(), (String[])new String[0]) + "):" + (int)var15_24);
            data.put("updated", key);
            data.put("updated-exists", true);
            final int next = PL.next(0, 100);
            if (next % 3 == 0) {
                if (!lemonEngine.get(key).exists()) {
                    throw DBOpeException.from((String)("error, key is deleted???: " + (String)key));
                }
                LemonEngine.CompareAndSetResult compareAndSetResult = lemonEngine.compareAndSet(key, new LemonEngine.CompareAndSet(){

                    public LemonEngine.Setter test(LemonEngine.GetResult fileGetResult, LemonEngine.Operator operator) {
                        if (fileGetResult.vcc() % 3L == 0L) {
                            noopCount.incrementAndGet();
                            return operator.noop();
                        }
                        Map map = fileGetResult.value();
                        map.put("compareAndSet", "ok-" + next);
                        compareAndSetCount.incrementAndGet();
                        return operator.update().data(map);
                    }
                });
                if (compareAndSetResult.noop() || !compareAndSetResult.updated().updated()) continue;
                LemonEngine.GetResult gf = lemonEngine.get(key);
                if (!concurrency && gf.vcc() == compareAndSetResult.updated().vcc() && !gf.value().containsKey("compareAndSet")) {
                    throw DBOpeException.from((String)("compareAndSet error: " + (String)key + ", " + JSONAccessor.impl().format((Object)gf.value())));
                }
                updateExistsSet.add(key);
                if (var15_24++ <= updateCount) continue;
                break;
            }
            LemonEngine.PutResult put = lemonEngine.put(key, data);
            if (!put.updated()) continue;
            LemonEngine.GetResult getResult2 = lemonEngine.get(key);
            if (getResult2 == null || put.vcc() != getResult2.vcc() || !getResult2.value().containsKey("updated-exists")) {
                throw DBOpeException.from((String)("update error: " + (String)key + ", " + JSONAccessor.impl().format((Object)getResult2.value())));
            }
            updateExistsSet.add(key);
            if (var15_24++ <= updateCount) continue;
            break;
        }
        log.info("updated-exists completed: " + (int)var15_24 + ", compareAndSet noop: " + noopCount.get() + ", compareAndSet updated: " + compareAndSetCount.get());
        PL.search(lemonEngine, concurrency, filePutResultMap, realDeletedKeySet, PREFIX);
        HashSet<String> recoveryDeletedSet = new HashSet<String>();
        boolean bl2 = false;
        for (Map.Entry entry : new HashMap<String, LemonEngine.PutResult>(filePutResultMap).entrySet()) {
            String key = (String)entry.getKey();
            if (!realDeletedKeySet.containsKey(key)) continue;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("desc", "update-desc(" + Util.formatTime((LocalDateTime)LocalDateTime.now(), (String[])new String[0]) + "):" + (int)var19_30);
            data.put("updated-deleted", key);
            LemonEngine.PutResult putResult = lemonEngine.put(key, data);
            if (putResult.created()) {
                recoveryDeletedSet.add(key);
                realDeletedKeySet.remove(key);
                if (++var19_30 <= updateCount) continue;
                break;
            }
            throw DBOpeException.from((String)("(recreate) / updated deleted error: " + key));
        }
        log.info("recovery deleted count: " + (int)var19_30 + "/ " + recoveryDeletedSet.size());
        PL.search(lemonEngine, concurrency, filePutResultMap, realDeletedKeySet, PREFIX);
        String start = null;
        int n = new Random().nextInt(filePutResultMap.size());
        int ic = 0;
        for (Map.Entry entry : filePutResultMap.entrySet()) {
            if (ic++ <= n) continue;
            start = (String)entry.getKey();
            break;
        }
        LinkedHashMap<String, LemonEngine.GetResult> searchAfterMap = new LinkedHashMap<String, LemonEngine.GetResult>();
        int searchAfterCount = 0;
        for (LemonEngine.GetResult fileGetResult : lemonEngine.searchAfter(start, false, 100)) {
            String seq = fileGetResult.key();
            if (seq.compareTo(start) <= 0) {
                throw DBOpeException.from((String)("searchAfter error: " + (String)seq));
            }
            ++searchAfterCount;
            searchAfterMap.put(seq, fileGetResult);
        }
        log.info("searchAfter( < " + start + ") completed, searchAfter count: " + searchAfterCount + "/ " + searchAfterMap.size());
        LinkedHashMap<String, LemonEngine.GetResult> searchBeforeMap = new LinkedHashMap<String, LemonEngine.GetResult>();
        int searchBeforeCount = 0;
        for (LemonEngine.GetResult fileGetResult : lemonEngine.searchBefore(start, false, 100)) {
            String seq = fileGetResult.key();
            if (seq.compareTo(start) > 0) {
                throw DBOpeException.from((String)("searchBefore error: " + seq + " > " + start));
            }
            ++searchBeforeCount;
            searchBeforeMap.put(seq, fileGetResult);
        }
        log.info("searchBefore( > " + start + ") completed, searchBefore count: " + searchBeforeCount + "/ " + searchBeforeMap.size());
        int tailCount = 0;
        LinkedHashMap<String, LemonEngine.GetResult> tailMap = new LinkedHashMap<String, LemonEngine.GetResult>();
        AtomicReference<LemonEngine.GetResult> last = new AtomicReference<LemonEngine.GetResult>();
        for (LemonEngine.GetResult fileGetResult : lemonEngine.tail(100)) {
            String seq = fileGetResult.key();
            if (tailMap.isEmpty()) {
                tailMap.put(seq, fileGetResult);
                last.set(fileGetResult);
                continue;
            }
            tailMap.put(seq, fileGetResult);
            if (seq.compareTo(((LemonEngine.GetResult)last.get()).key()) > 0) {
                throw DBOpeException.from((String)("tail error: " + (String)seq));
            }
            ++tailCount;
            last.set(fileGetResult);
        }
        log.info("tail completed, tail count: " + tailCount);
        int topCount = 0;
        LinkedHashMap<String, LemonEngine.GetResult> topMap = new LinkedHashMap<String, LemonEngine.GetResult>();
        last = new AtomicReference();
        for (LemonEngine.GetResult fileGetResult : lemonEngine.top(100)) {
            String key = fileGetResult.key();
            if (topMap.isEmpty()) {
                topMap.put(key, fileGetResult);
                last.set(fileGetResult);
                continue;
            }
            topMap.put(key, fileGetResult);
            if (key.compareTo(((LemonEngine.GetResult)last.get()).key()) < 0) {
                throw DBOpeException.from((String)("top error: " + key));
            }
            ++topCount;
            last.set(fileGetResult);
        }
        log.info("top completed, top count: " + topCount);
        log.info("to do search / regex ");
        int regexCount = 0;
        final Pattern pattern = Pattern.compile(".+7.+8.*");
        List regexResultList = lemonEngine.searchAfter(start, false, 100, (Predicate)new Predicate<String>(){

            @Override
            public boolean test(String s) {
                return pattern.matcher(s).matches();
            }
        });
        for (LemonEngine.GetResult fileGetResult : regexResultList) {
            String key = fileGetResult.key();
            if (!pattern.matcher(key).matches()) {
                throw DBOpeException.from((String)("error: " + key));
            }
            ++regexCount;
        }
        log.info("search / regex completed, search / regex count: " + regexCount);
        log.info("to do get, then check , filePutResultMap: " + filePutResultMap.size() + ", realDeletedKeySet: " + realDeletedKeySet.size() + ", recoveryDeletedSet: " + recoveryDeletedSet.size());
        int getCount = 0;
        for (String k : filePutResultMap.keySet()) {
            LemonEngine.GetResult fileGetResult = lemonEngine.get(k);
            if (fileGetResult != null && !fileGetResult.exists()) {
                if (realDeletedKeySet.containsKey(k)) continue;
                throw DBOpeException.from((String)("should be existing: " + k + ", selfDelCount: " + selfDelCount + ", recoveryDeletedCount: " + (int)var19_30));
            }
            ++getCount;
        }
        log.info("get completed, get count: " + getCount + "/ " + filePutResultMap.size() + "/ (checkDeleted: " + (filePutResultMap.size() - getCount == realDeletedKeySet.size()) + ", " + (filePutResultMap.size() - getCount) + "==?" + realDeletedKeySet.size() + "), selfDelCount: " + selfDelCount + ", recoveryDeletedCount: " + (int)var19_30);
        if (filePutResultMap.size() - getCount != realDeletedKeySet.size()) {
            throw DBOpeException.from((String)"DATA ERROR");
        }
        log.info("----------------------- doSerial ( " + taskIndex + " ) all ok ( cost: " + Util.costTime((long)allStart) + " ) ---------");
        if (taskIndex % 30 == 0) {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.out);
            lemonEngine.pretty(outputStreamWriter);
            outputStreamWriter.flush();
            System.out.println("\r\n");
        }
    }

    private static void snapshot(LemonEngine lemonEngine) throws Exception {
        long startTime = System.currentTimeMillis();
        final ArrayList keyList = new ArrayList(lemonEngine.count());
        final AtomicInteger count = new AtomicInteger();
        LemonEngine.DumpConf dumpConf = new LemonEngine.DumpConf();
        dumpConf.setSnapshotCreatedWaitTimeSec(3600L);
        final AtomicInteger c = new AtomicInteger();
        Tests.dump((LemonEngine)lemonEngine, (LemonEngine.SearchListener)new LemonEngine.SearchListener(){

            public void onRow(LemonEngine.GetResult getResult, LemonEngine.SearchContext searchContext) {
                keyList.add(getResult.key());
                if (c.incrementAndGet() > 999000) {
                    searchContext.cancel();
                }
            }
        }, (DefaultLemonEngine.DumpStatListener)new DefaultLemonEngine.DumpStatListener(){

            public void onCount(int c) {
                count.set(c);
            }

            public void onDiskFileStat(String diskFileStat) {
                log.info("\r\n============== snapshot ==============\r\n" + diskFileStat);
            }
        }, (LemonEngine.DumpConf)dumpConf);
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
            lemonEngine.pretty(outputStreamWriter);
            outputStreamWriter.flush();
            log.info("\r\n============== source ==============\r\n" + Util.utf8((byte[])byteArrayOutputStream.toByteArray()));
        }
        log.info("snapshot size: " + (keyList.size() == count.get()) + ", " + keyList.size() + " ==?" + count.get() + " , " + (keyList.size() == count.get()) + ", source: " + lemonEngine.count() + ", cost: " + Util.costTime((long)startTime));
        if (keyList.size() != count.get()) {
            throw DBOpeException.from((String)"SNAPSHOT ERROR");
        }
    }

    private static void truncate(final LemonEngine lemonEngine) {
        final int sum = lemonEngine.count();
        if (sum < 300000) {
            return;
        }
        log.info("to get x lock , ready truncate: " + sum);
        PL.x_lock(new DoInLock<Void>(){

            @Override
            public Void doInLock() {
                List list;
                log.info("got x lock , begin truncate: " + sum);
                long start = System.currentTimeMillis();
                int count = 0;
                String deleteKey = null;
                while (!Util.isEmpty((Collection)(list = lemonEngine.searchAfter(deleteKey, false, 1000)))) {
                    for (LemonEngine.GetResult fileGetResult : list) {
                        deleteKey = fileGetResult.key();
                        lemonEngine.delete(deleteKey);
                        ++count;
                    }
                    if (count <= sum / 3) continue;
                    break;
                }
                log.info("truncate ok ,search sum: " + sum + ", delete: " + count + ", cost: " + Util.costTime((long)start));
                return null;
            }
        }, Integer.MAX_VALUE, TimeUnit.SECONDS);
        log.info("release x lock , truncate ok ");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T x_lock(DoInLock<T> doInLock, long time, TimeUnit unit) {
        try (ReleasableLock metaXLock = xLock.acquire(time, unit);){
            if (metaXLock == null) {
                throw new TimeoutException("metaXLock timeout: " + unit.toSeconds(time));
            }
            T t = doInLock.doInLock();
            return t;
        }
        catch (Exception e) {
            throw DBOpeException.from((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T s_lock(DoInLock<T> doInLock, long time, TimeUnit unit) {
        try (ReleasableLock metaSLock = sLock.acquire(time, unit);){
            if (metaSLock == null) {
                throw new TimeoutException("metaSLock timeout: " + unit.toSeconds(time));
            }
            T t = doInLock.doInLock();
            return t;
        }
        catch (Exception e) {
            throw DBOpeException.from((Throwable)e);
        }
    }

    private static interface DoInLock<T> {
        public T doInLock();
    }

    static interface Check {
        public boolean valid(long var1, long var3, LemonEngine.GetResult var5);
    }
}

