/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.module.shared.jdk21.test;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.delay.DelayTask;
import com.ovopark.kernel.shared.delay.TimingWheel;
import com.ovopark.kernel.shared.delay.TimingWheelTimer;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class D {
    private static final Logger log = LoggerFactory.getLogger(D.class);

    public static void main(String[] args) throws InterruptedException {
        ExecutorService executorService = Executors.newFixedThreadPool(3, Util.newThreadFactory((String)"execute-task"));
        TimingWheel timingWheelTimer = new TimingWheel("D", 1000, 20, executorService);
        final LocalDateTime now = LocalDateTime.now();
        Executors.newFixedThreadPool(1).execute(new Runnable(){
            final /* synthetic */ TimingWheelTimer val$timingWheelTimer;
            {
                this.val$timingWheelTimer = timingWheelTimer;
            }

            @Override
            public void run() {
                for (int i = 0; i < 1000000; ++i) {
                    DTask delayTask = new DTask("i-" + i, now.plus(1 + i, ChronoUnit.MILLIS));
                    this.val$timingWheelTimer.delay((DelayTask)delayTask);
                }
            }
        });
        Executors.newScheduledThreadPool(1).scheduleWithFixedDelay(new Runnable((TimingWheelTimer)timingWheelTimer){
            final /* synthetic */ TimingWheelTimer val$timingWheelTimer;
            {
                this.val$timingWheelTimer = timingWheelTimer;
            }

            @Override
            public void run() {
                TimingWheelTimer.TimingWheelStat stat = this.val$timingWheelTimer.stat();
                log.info(JSONAccessor.impl().format((Object)stat));
            }
        }, 0L, 3L, TimeUnit.SECONDS);
        Executors.newScheduledThreadPool(1).scheduleWithFixedDelay(new Runnable((TimingWheelTimer)timingWheelTimer){
            final /* synthetic */ TimingWheelTimer val$timingWheelTimer;
            {
                this.val$timingWheelTimer = timingWheelTimer;
            }

            @Override
            public void run() {
                final ArrayList list = new ArrayList();
                this.val$timingWheelTimer.seek((Consumer)new Consumer<DelayTask>(){

                    @Override
                    public void accept(DelayTask delayTask) {
                        Comparable taskId = delayTask.taskId();
                        list.add(taskId);
                    }
                }, 300);
                log.info(JSONAccessor.impl().format(list));
            }
        }, 0L, 3L, TimeUnit.SECONDS);
        TimeUnit.SECONDS.sleep(30000L);
    }

    static class DTask
    implements DelayTask {
        final String name;
        final LocalDateTime triggerTime;

        public DTask(String name, LocalDateTime triggerTime) {
            this.name = name;
            this.triggerTime = triggerTime;
        }

        public long triggerTimeMs() {
            return this.triggerTime.toInstant(Util.GMT_08).toEpochMilli();
        }

        public String taskId() {
            return this.name;
        }

        public Runnable task() {
            return new Runnable(){

                @Override
                public void run() {
                    log.info(name + ", trigger time: " + Util.formatTime((LocalDateTime)triggerTime, (String[])new String[]{"HH:mm:ss.SSS"}) + ", now: " + Util.formatTime((LocalDateTime)LocalDateTime.now(), (String[])new String[]{"HH:mm:ss.SSS"}));
                }
            };
        }
    }
}

