/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.module.shared.jdk21.test;

import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.delay.DelayTask;
import com.ovopark.kernel.shared.delay.TimingWheel;
import com.ovopark.kernel.shared.delay.TimingWheelTimer;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class D1 {
    private static final Logger log = LoggerFactory.getLogger(D1.class);
    static AtomicLong expiredCount = new AtomicLong();
    static AtomicLong writeCount = new AtomicLong();

    public static void main(String[] args) throws InterruptedException {
        ExecutorService executorService = Executors.newFixedThreadPool(3, Util.newThreadFactory((String)"execute-task"));
        final int wheelSize = 3;
        TimingWheel timingWheelTimer = new TimingWheel("D1", 1000, wheelSize, 200, executorService);
        int i = Runtime.getRuntime().availableProcessors();
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(i);
        scheduledExecutorService = Executors.newScheduledThreadPool(i);
        for (int i1 = 0; i1 < i; ++i1) {
            Random random = new Random();
            scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){
                final /* synthetic */ TimingWheelTimer val$timingWheelTimer;
                {
                    this.val$timingWheelTimer = timingWheelTimer;
                }

                @Override
                public void run() {
                    LocalDateTime now = LocalDateTime.now();
                    int i2 = 0;
                    while (i2 < wheelSize * 2) {
                        int t = i2++;
                        LocalDateTime plus = now.plus(t, ChronoUnit.SECONDS);
                        DTask delayTask = new DTask("2S-" + t, plus);
                        this.val$timingWheelTimer.delay((DelayTask)delayTask);
                        writeCount.incrementAndGet();
                    }
                }
            }, 0L, 10L, TimeUnit.MILLISECONDS);
        }
        Executors.newScheduledThreadPool(1).scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                log.info("write count: " + writeCount.get() + ", expired: " + expiredCount.get());
            }
        }, 0L, 3L, TimeUnit.SECONDS);
        TimeUnit.SECONDS.sleep(30000L);
    }

    static class DTask
    implements DelayTask {
        final String name;
        final LocalDateTime triggerTime;

        public DTask(String name, LocalDateTime triggerTime) {
            this.name = name;
            this.triggerTime = triggerTime;
        }

        public long triggerTimeMs() {
            return this.triggerTime.toInstant(Util.GMT_08).toEpochMilli();
        }

        public Long taskId() {
            return null;
        }

        public Runnable task() {
            return new Runnable(this){

                @Override
                public void run() {
                    expiredCount.incrementAndGet();
                }
            };
        }
    }
}

