/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.java21;

import com.ovopark.module.shared.AsyncTaskService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeoutException;

public class LoomAsyncTaskService
implements AsyncTaskService {
    static final ThreadFactory factory = Thread.ofVirtual().inheritInheritableThreadLocals(true).factory();

    public AsyncTaskService.AsyncFuture async(Runnable runnable) {
        ExecutorService executorService = Executors.newThreadPerTaskExecutor(factory);
        Future<?> future = executorService.submit(runnable);
        return new LoomAsyncFutureImpl(future);
    }

    static class LoomAsyncFutureImpl<V>
    implements AsyncTaskService.AsyncFuture<V> {
        private final Future<V> future;

        public LoomAsyncFutureImpl(Future<V> future) {
            this.future = future;
        }

        public V get() throws InterruptedException, ExecutionException, TimeoutException {
            return this.future.get();
        }
    }
}

