/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.kernel.shared.concurrent;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;

public class ReleasableLock
implements Closeable {
    private transient Thread exclusiveOwnerThread;
    private final Lock lock;

    public ReleasableLock(Lock lock) {
        this.lock = lock;
    }

    public ReleasableLock acquire() {
        this.lock.lock();
        return this;
    }

    public ReleasableLock acquire(long time, TimeUnit unit) throws InterruptedException {
        boolean locked = this.lock.tryLock(time, unit);
        if (locked) {
            return this;
        }
        return null;
    }

    public void unlock() {
        this.lock.unlock();
    }

    @Override
    public void close() throws IOException {
        this.unlock();
    }
}

