/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.kernel.shared.kv;

import com.ovopark.kernel.shared.CachedExecutors;
import com.ovopark.kernel.shared.DBOpeException;
import com.ovopark.kernel.shared.ServiceProvider;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.concurrent.KeyLockLock;
import com.ovopark.kernel.shared.delay.DelayTask;
import com.ovopark.kernel.shared.delay.TimingWheel;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public interface CacheService<K extends Comparable, V> {
    @Deprecated
    public V expire(K var1, V var2, long var3, TimeUnit var5);

    public V expire(K var1, V var2);

    default public void set(K key, V object) {
        this.expire(key, object);
    }

    public V get(K var1);

    public V remove(K var1);

    public boolean contains(K var1);

    default public Object backend() {
        throw new UnsupportedOperationException();
    }

    default public Collection<K> keys() {
        throw new UnsupportedOperationException();
    }

    default public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    default public V seek() {
        throw new UnsupportedOperationException();
    }

    default public void forEach(BiConsumer<? super K, ? super V> action) {
        throw new UnsupportedOperationException();
    }

    default public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    default public boolean expire(K key, long time, TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    default public boolean atomicUpdate(K key, Function<V, V> func) {
        throw new UnsupportedOperationException();
    }

    default public boolean atomicUpdate(K key, Function<V, V> func, long time, TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    default public V updateAndGet(K key, Function<V, V> func, long time, TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    default public V updateAndGet(K key, Function<V, V> func, long time, TimeUnit timeUnit, boolean updateExpiredTime) {
        throw new UnsupportedOperationException();
    }

    default public V updateAndGet(K key, Function<V, V> func) {
        throw new UnsupportedOperationException();
    }

    default public V getAndUpdate(K key, Function<V, V> func) {
        throw new UnsupportedOperationException();
    }

    default public V getAndUpdate(K key, Function<V, V> func, long time, TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    default public V getAndUpdate(K key, Function<V, V> func, long time, TimeUnit timeUnit, boolean updateExpiredTime) {
        throw new UnsupportedOperationException();
    }

    default public V putIfAbsentAndGet(K key, Supplier<V> func, long time, TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    default public V leaseAndGet(K key, long time, TimeUnit timeUnit, Function<V, V> func) {
        throw new UnsupportedOperationException();
    }

    default public V getAndLease(K key, long time, TimeUnit timeUnit, Function<V, V> func) {
        throw new UnsupportedOperationException();
    }

    default public void shutdown() throws Exception {
        throw new UnsupportedOperationException();
    }

    default public int size() {
        throw new UnsupportedOperationException();
    }

    public static <K extends Comparable, V> CacheService<K, V> map() {
        return new MapCacheService(true);
    }

    @Deprecated
    public static CacheService<String, Object> staticMap() {
        return MapCacheService.staticCacheRef;
    }

    @Deprecated
    public static CacheService<String, Object> staticCache() {
        return SimpleCacheService.staticCacheRef;
    }

    @Deprecated
    public static class MapCacheService<K extends Comparable, V>
    implements CacheService<K, V>,
    Closeable {
        private static final Logger log = LoggerFactory.getLogger(MapCacheService.class);
        private static final CachedExecutors DEFAULT = CachedExecutors.impl("map-cache");
        private final Map<K, Entry<K, V>> repo = new ConcurrentHashMap<K, Entry<K, V>>();
        private final boolean expired;
        private final List<RemovedCallBack> removedCallBackList = new CopyOnWriteArrayList<RemovedCallBack>();
        private static final RemovedCallBack LOGGER_CALL_BACK = (object, startTime, now, expiredTime) -> log.info(object.getKey() + " removed,expired time: " + object.getExpiredMilli());
        private static final MapCacheService<String, Object> staticCacheRef = new MapCacheService(true);
        private final KeyLockLock keyLockLock = new KeyLockLock();
        private TimingWheel timingWheel;

        public MapCacheService() {
            this(false);
        }

        public MapCacheService(boolean expired) {
            this(expired, DEFAULT);
        }

        public MapCacheService(boolean expired, RemovedCallBack removedCallBack) {
            this(expired, DEFAULT, removedCallBack);
        }

        public MapCacheService(boolean expired, ExecutorService executorService) {
            this(expired, executorService, null);
        }

        public MapCacheService(boolean expired, ExecutorService executorService, RemovedCallBack removedCallBack) {
            this(expired, executorService, removedCallBack, 1000);
        }

        public MapCacheService(boolean expired, ExecutorService executorService, RemovedCallBack removedCallBack, int timeoutMs) {
            this.expired = expired;
            if (this.expired) {
                if (removedCallBack != null) {
                    this.removedCallBackList.add(removedCallBack);
                }
                this.timingWheel = new TimingWheel(this.toString(), 1, 20, Math.max(timeoutMs, 100), executorService);
            }
        }

        protected MapCacheService(boolean expired, RemovedCallBack removedCallBack, int timeoutMs) {
            this.expired = expired;
            if (this.expired) {
                if (removedCallBack != null) {
                    this.removedCallBackList.add(removedCallBack);
                }
                this.timingWheel = new TimingWheel(this.toString(), 1, 20, Math.max(timeoutMs, 100), null);
            }
        }

        @Deprecated
        public MapCacheService(boolean expired, CachedExecutors cachedExecutors) {
            this(expired, cachedExecutors, null);
        }

        @Deprecated
        public MapCacheService(boolean expired, CachedExecutors cachedExecutors, RemovedCallBack removedCallBack) {
            this(expired, cachedExecutors, removedCallBack, 1000);
        }

        @Deprecated
        public MapCacheService(boolean expired, CachedExecutors cachedExecutors, RemovedCallBack removedCallBack, int timeoutMs) {
            this.expired = expired;
            if (this.expired) {
                if (removedCallBack != null) {
                    this.removedCallBackList.add(removedCallBack);
                }
                this.timingWheel = new TimingWheel(this.toString(), 1, 20, Math.max(timeoutMs, 100), cachedExecutors.executorService());
            }
        }

        @Override
        public void close() throws IOException {
            try {
                this.shutdown();
            }
            catch (Exception e) {
                throw Util.convert2RuntimeException(e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        @Deprecated
        public V expire(K key, V object, long time, TimeUnit timeUnit) {
            Objects.requireNonNull(key);
            try (KeyLockLock.KeyLock lock = this.keyLockLock.lock((Comparable<?>)key);){
                V v = this.getAndCreateEntry0(key, object, time, timeUnit);
                return v;
            }
            catch (IOException e) {
                throw DBOpeException.from(e);
            }
        }

        private V getAndCreateEntry0(K key, V object, long time, TimeUnit timeUnit) {
            Objects.requireNonNull(key);
            long expired = timeUnit.toMillis(time);
            Entry entry = new Entry();
            entry.key = key;
            entry.value = object;
            entry.startMilli = System.currentTimeMillis();
            entry.expiredMilli = expired;
            Entry old = this.repo.put(key, entry);
            if (this.expired && time != Integer.MAX_VALUE && time != Long.MAX_VALUE) {
                TTLEntry ttlEntry = new TTLEntry(this, key, entry.startMilli + entry.expiredMilli, entry.vcc);
                this.timingWheel.delay(ttlEntry);
            }
            return (V)(old == null ? null : old.value);
        }

        @Override
        public V expire(K key, V object) {
            return this.expire(key, object, Integer.MAX_VALUE, TimeUnit.SECONDS);
        }

        @Override
        public V get(K key) {
            Entry<K, V> entry = this.repo.get(key);
            if (entry != null) {
                long now = System.currentTimeMillis();
                if (now - ((Entry)entry).startMilli > ((Entry)entry).expiredMilli) {
                    return null;
                }
                return entry.getValue();
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public V remove(K key) {
            Entry<K, V> entry = this.repo.get(key);
            if (entry == null) {
                return null;
            }
            try (KeyLockLock.KeyLock lock = this.keyLockLock.lock((Comparable<?>)entry.getKey());){
                entry = this.repo.remove(key);
                if (entry == null) return null;
                V v = entry.getValue();
                return v;
            }
            catch (IOException e) {
                throw DBOpeException.from(e);
            }
        }

        @Override
        public boolean contains(K key) {
            return this.repo.containsKey(key);
        }

        @Override
        public Collection<K> keys() {
            return Collections.unmodifiableCollection(this.repo.keySet());
        }

        @Override
        public Collection<V> values() {
            return Collections.unmodifiableCollection(this.repo.values().stream().map(entry -> entry.getValue()).collect(Collectors.toList()));
        }

        @Override
        public V seek() {
            return this.repo.entrySet().iterator().next().getValue().getValue();
        }

        @Override
        public void forEach(BiConsumer<? super K, ? super V> action) {
            this.repo.forEach((key, entry) -> action.accept((Object)key, (Object)entry.getValue()));
        }

        @Override
        public boolean isEmpty() {
            return this.repo.isEmpty();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean expire(K key, long time, TimeUnit timeUnit) {
            Objects.requireNonNull(key);
            Entry<K, V> entry = this.repo.get(key);
            if (entry == null) {
                return false;
            }
            try (KeyLockLock.KeyLock lock = this.keyLockLock.lock((Comparable<?>)entry.getKey());){
                entry = this.repo.get(key);
                if (entry == null) {
                    boolean bl2 = false;
                    return bl2;
                }
                long expiredTime = timeUnit.toMillis(time);
                entry.setStartMilli(System.currentTimeMillis());
                entry.setExpiredMilli(expiredTime);
                ((Entry)entry).vcc++;
                if (this.expired && time != Integer.MAX_VALUE && time != Long.MAX_VALUE) {
                    TTLEntry ttlEntry = new TTLEntry(this, key, ((Entry)entry).startMilli + ((Entry)entry).expiredMilli, ((Entry)entry).vcc);
                    this.timingWheel.delay(ttlEntry);
                }
                this.repo.put(key, entry);
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                throw DBOpeException.from(e);
            }
        }

        @Override
        public V updateAndGet(K key, Function<V, V> func, long time, TimeUnit timeUnit) {
            return this.updateAndGet(key, func, time, timeUnit, false);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public V updateAndGet(K key, Function<V, V> func, long time, TimeUnit timeUnit, boolean updateExpiredTime) {
            Objects.requireNonNull(key);
            try (KeyLockLock.KeyLock lock = this.keyLockLock.lock((Comparable<?>)key);){
                V applied;
                Entry<K, V> entry = this.repo.get(key);
                if (entry == null) {
                    applied = func.apply(null);
                    this.getAndCreateEntry0(key, applied, time, timeUnit);
                } else {
                    applied = func.apply(entry.getValue());
                    entry.setValue(applied);
                    if (updateExpiredTime) {
                        entry.setExpiredMilli(timeUnit.toMillis(time));
                        ((Entry)entry).vcc++;
                        if (this.expired && time != Integer.MAX_VALUE && time != Long.MAX_VALUE) {
                            TTLEntry ttlEntry = new TTLEntry(this, key, ((Entry)entry).startMilli + ((Entry)entry).expiredMilli, ((Entry)entry).vcc);
                            this.timingWheel.delay(ttlEntry);
                        }
                    }
                }
                V v = applied;
                return v;
            }
            catch (IOException e) {
                throw DBOpeException.from(e);
            }
        }

        @Override
        public V updateAndGet(K key, Function<V, V> func) {
            return this.updateAndGet(key, func, Integer.MAX_VALUE, TimeUnit.SECONDS);
        }

        @Override
        public V getAndUpdate(K key, Function<V, V> func) {
            return this.getAndUpdate(key, func, Integer.MAX_VALUE, TimeUnit.SECONDS);
        }

        @Override
        public V getAndUpdate(K key, Function<V, V> func, long time, TimeUnit timeUnit) {
            return this.getAndUpdate(key, func, time, timeUnit, false);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public V getAndUpdate(K key, Function<V, V> func, long time, TimeUnit timeUnit, boolean updateExpiredTime) {
            Objects.requireNonNull(key);
            try (KeyLockLock.KeyLock lock = this.keyLockLock.lock((Comparable<?>)key);){
                Entry<K, V> entry = this.repo.get(key);
                if (entry == null) {
                    V applied = func.apply(null);
                    this.getAndCreateEntry0(key, applied, time, timeUnit);
                    V v = null;
                    return v;
                }
                V old = entry.getValue();
                V applied = func.apply(entry.getValue());
                entry.setValue(applied);
                if (updateExpiredTime) {
                    entry.setExpiredMilli(timeUnit.toMillis(time));
                    ((Entry)entry).vcc++;
                    if (this.expired && time != Integer.MAX_VALUE && time != Long.MAX_VALUE) {
                        TTLEntry ttlEntry = new TTLEntry(this, key, ((Entry)entry).startMilli + ((Entry)entry).expiredMilli, ((Entry)entry).vcc);
                        this.timingWheel.delay(ttlEntry);
                    }
                }
                V v = old;
                return v;
            }
            catch (IOException e) {
                throw DBOpeException.from(e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public V putIfAbsentAndGet(K key, Supplier<V> func, long time, TimeUnit timeUnit) {
            Objects.requireNonNull(key);
            V v = this.get(key);
            if (v != null) {
                return v;
            }
            try (KeyLockLock.KeyLock lock = this.keyLockLock.lock((Comparable<?>)key);){
                v = this.get(key);
                if (v != null) {
                    V v2 = v;
                    return v2;
                }
                V object = func.get();
                this.getAndCreateEntry0(key, object, time, timeUnit);
                V v3 = object;
                return v3;
            }
            catch (IOException e) {
                throw DBOpeException.from(e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean atomicUpdate(K key, Function<V, V> func) {
            Objects.requireNonNull(key);
            try (KeyLockLock.KeyLock lock = this.keyLockLock.lock((Comparable<?>)key);){
                Entry<K, V> entry = this.repo.get(key);
                if (entry == null) {
                    boolean bl2 = false;
                    return bl2;
                }
                V applied = func.apply(entry.getValue());
                entry.setValue(applied);
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                throw DBOpeException.from(e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean atomicUpdate(K key, Function<V, V> func, long time, TimeUnit timeUnit) {
            Objects.requireNonNull(key);
            try (KeyLockLock.KeyLock lock = this.keyLockLock.lock((Comparable<?>)key);){
                Entry<K, V> entry = this.repo.get(key);
                if (entry == null) {
                    boolean bl2 = false;
                    return bl2;
                }
                V applied = func.apply(entry.getValue());
                entry.setValue(applied);
                ((Entry)entry).expiredMilli = timeUnit.toMillis(time);
                ((Entry)entry).vcc++;
                if (this.expired && time != Integer.MAX_VALUE && time != Long.MAX_VALUE) {
                    TTLEntry ttlEntry = new TTLEntry(this, key, ((Entry)entry).startMilli + ((Entry)entry).expiredMilli, ((Entry)entry).vcc);
                    this.timingWheel.delay(ttlEntry);
                }
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                throw DBOpeException.from(e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public V leaseAndGet(K key, long time, TimeUnit timeUnit, Function<V, V> func) {
            Objects.requireNonNull(key);
            try (KeyLockLock.KeyLock lock = this.keyLockLock.lock((Comparable<?>)key);){
                Entry<K, V> entry = this.repo.get(key);
                if (entry == null) {
                    V applied = func.apply(null);
                    this.getAndCreateEntry0(key, applied, time, timeUnit);
                    V v = applied;
                    return v;
                }
                entry.setValue(func.apply(entry.getValue()));
                entry.setStartMilli(System.currentTimeMillis());
                entry.setExpiredMilli(timeUnit.toMillis(time));
                ((Entry)entry).vcc++;
                if (this.expired && time != Integer.MAX_VALUE && time != Long.MAX_VALUE) {
                    TTLEntry ttlEntry = new TTLEntry(this, key, ((Entry)entry).startMilli + ((Entry)entry).expiredMilli, ((Entry)entry).vcc);
                    this.timingWheel.delay(ttlEntry);
                }
                V v = entry.getValue();
                return v;
            }
            catch (IOException e) {
                throw DBOpeException.from(e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public V getAndLease(K key, long time, TimeUnit timeUnit, Function<V, V> func) {
            Objects.requireNonNull(key);
            try (KeyLockLock.KeyLock lock = this.keyLockLock.lock((Comparable<?>)key);){
                Entry<K, V> entry = this.repo.get(key);
                if (entry == null) {
                    V applied = func.apply(null);
                    this.getAndCreateEntry0(key, applied, time, timeUnit);
                    V v = null;
                    return v;
                }
                V oldValue = entry.getValue();
                entry.setValue(func.apply(oldValue));
                entry.setStartMilli(System.currentTimeMillis());
                entry.setExpiredMilli(timeUnit.toMillis(time));
                ((Entry)entry).vcc++;
                if (this.expired && time != Integer.MAX_VALUE && time != Long.MAX_VALUE) {
                    TTLEntry ttlEntry = new TTLEntry(this, key, ((Entry)entry).startMilli + ((Entry)entry).expiredMilli, ((Entry)entry).vcc);
                    this.timingWheel.delay(ttlEntry);
                }
                V v = oldValue;
                return v;
            }
            catch (IOException e) {
                throw DBOpeException.from(e);
            }
        }

        @Override
        public Object backend() {
            return this.repo;
        }

        @Override
        public void shutdown() throws Exception {
            try {
                this.timingWheel.shutdown();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            this.repo.clear();
        }

        @Override
        public int size() {
            return this.repo.size();
        }

        static {
            ServiceLoader<RemovedCallBackProvider> serviceLoader = ServiceLoader.load(RemovedCallBackProvider.class);
            for (RemovedCallBackProvider removedCallBackProvider : serviceLoader) {
                RemovedCallBack removedCallBack = (RemovedCallBack)removedCallBackProvider.get();
                MapCacheService.staticCacheRef.removedCallBackList.add(removedCallBack);
            }
            MapCacheService.staticCacheRef.removedCallBackList.add(LOGGER_CALL_BACK);
        }

        @Deprecated
        public static interface RemovedCallBack<K extends Comparable, V> {
            public void call(Entry<K, V> var1, long var2, long var4, long var6);
        }

        @Deprecated
        public static class Entry<K extends Comparable, V> {
            private K key;
            private V value;
            private long startMilli;
            private long expiredMilli;
            private final AtomicLong ver = new AtomicLong(0L);
            private volatile long vcc;

            public K getKey() {
                return this.key;
            }

            public V getValue() {
                return this.value;
            }

            public long getStartMilli() {
                return this.startMilli;
            }

            public long getExpiredMilli() {
                return this.expiredMilli;
            }

            public AtomicLong getVer() {
                return this.ver;
            }

            public long getVcc() {
                return this.vcc;
            }

            public void setKey(K key) {
                this.key = key;
            }

            public void setValue(V value) {
                this.value = value;
            }

            public void setStartMilli(long startMilli) {
                this.startMilli = startMilli;
            }

            public void setExpiredMilli(long expiredMilli) {
                this.expiredMilli = expiredMilli;
            }

            public void setVcc(long vcc) {
                this.vcc = vcc;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Entry)) {
                    return false;
                }
                Entry other = (Entry)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.getStartMilli() != other.getStartMilli()) {
                    return false;
                }
                if (this.getExpiredMilli() != other.getExpiredMilli()) {
                    return false;
                }
                if (this.getVcc() != other.getVcc()) {
                    return false;
                }
                K this$key = this.getKey();
                K other$key = other.getKey();
                if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                    return false;
                }
                V this$value = this.getValue();
                V other$value = other.getValue();
                if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                    return false;
                }
                AtomicLong this$ver = this.getVer();
                AtomicLong other$ver = other.getVer();
                return !(this$ver == null ? other$ver != null : !this$ver.equals(other$ver));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Entry;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                long $startMilli = this.getStartMilli();
                result = result * 59 + (int)($startMilli >>> 32 ^ $startMilli);
                long $expiredMilli = this.getExpiredMilli();
                result = result * 59 + (int)($expiredMilli >>> 32 ^ $expiredMilli);
                long $vcc = this.getVcc();
                result = result * 59 + (int)($vcc >>> 32 ^ $vcc);
                K $key = this.getKey();
                result = result * 59 + ($key == null ? 43 : $key.hashCode());
                V $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                AtomicLong $ver = this.getVer();
                result = result * 59 + ($ver == null ? 43 : $ver.hashCode());
                return result;
            }

            public String toString() {
                return "CacheService.MapCacheService.Entry(key=" + this.getKey() + ", value=" + this.getValue() + ", startMilli=" + this.getStartMilli() + ", expiredMilli=" + this.getExpiredMilli() + ", ver=" + this.getVer() + ", vcc=" + this.getVcc() + ")";
            }
        }

        class TTLEntry
        implements DelayTask {
            private final K key;
            private final long triggerTime;
            private final long vcc;
            final /* synthetic */ MapCacheService this$0;

            /*
             * WARNING - Possible parameter corruption
             * WARNING - void declaration
             */
            public TTLEntry(K vcc, long l, long l2) {
                void key;
                this.this$0 = (MapCacheService)this$0;
                this.key = key;
                this.triggerTime = triggerTime;
                this.vcc = (long)vcc;
            }

            @Override
            public long triggerTimeMs() {
                return this.triggerTime;
            }

            public K taskId() {
                return this.key;
            }

            @Override
            public Runnable task() {
                return new Runnable(){

                    @Override
                    public void run() {
                        boolean removedFlag = false;
                        Entry entry = (Entry)TTLEntry.this.this$0.repo.get(TTLEntry.this.key);
                        if (entry != null && entry.vcc == TTLEntry.this.vcc) {
                            try (KeyLockLock.KeyLock lock2 = TTLEntry.this.this$0.keyLockLock.lock((Comparable<?>)entry.getKey());){
                                entry = (Entry)TTLEntry.this.this$0.repo.get(TTLEntry.this.key);
                                if (entry != null && entry.vcc == TTLEntry.this.vcc) {
                                    TTLEntry.this.this$0.repo.remove(TTLEntry.this.key);
                                    removedFlag = true;
                                }
                            }
                            catch (Exception lock2) {
                                // empty catch block
                            }
                        }
                        if (removedFlag) {
                            long now = System.currentTimeMillis();
                            for (RemovedCallBack removedCallBack : TTLEntry.this.this$0.removedCallBackList) {
                                removedCallBack.call(entry, entry.startMilli, now, entry.expiredMilli);
                            }
                        }
                    }
                };
            }
        }

        @Deprecated
        public static interface RemovedCallBackProvider
        extends ServiceProvider<RemovedCallBack> {
        }
    }

    @Deprecated
    public static class SimpleCacheService<K extends Comparable<?>, V>
    extends MapCacheService<K, V> {
        private static final SimpleCacheService<String, Object> staticCacheRef = new SimpleCacheService(true);

        public SimpleCacheService(boolean expired) {
            this(expired, (TTLCallBack<K, V>)null);
        }

        public SimpleCacheService(boolean expired, TTLCallBack<K, V> ttlCallBack) {
            this(expired, 1000, ttlCallBack);
        }

        public SimpleCacheService(boolean expired, int timeoutMs, TTLCallBack<K, V> ttlCallBack) {
            super(expired, (MapCacheService.Entry<K, V> entry, long startTime, long scanTime, long expiredTime) -> {
                if (ttlCallBack == null) {
                    return;
                }
                ttlCallBack.call(entry.key, entry.value, entry.startMilli, entry.expiredMilli);
            }, timeoutMs);
        }
    }

    @Deprecated
    public static interface TTLCallBack<K extends Comparable<?>, V> {
        public void call(K var1, V var2, long var3, long var5);
    }
}

