/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.kernel.shared.stream.log;

import java.io.File;
import java.util.List;

public interface LogFileManager
extends AutoCloseable {
    public String module();

    public String logPath();

    public boolean isRollover(File var1);

    public void watch();

    public boolean submit(String var1);

    public List<String> inProcessingFiles();

    public boolean isProcessing(String var1);

    public Lag lag(String var1);

    public FileManagerStat managerStat();

    public static class FileStat {
        private String filePath;
        private long lastModifiedTime;
        private long timeLag;
        private long bytesLag;
        private long fileSize;
        private boolean support;
        private boolean autoScheduled;
        private boolean manualScheduled;
        private boolean dir;
        private String warning;
        private boolean active;

        public String getFilePath() {
            return this.filePath;
        }

        public long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public long getTimeLag() {
            return this.timeLag;
        }

        public long getBytesLag() {
            return this.bytesLag;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public boolean isSupport() {
            return this.support;
        }

        public boolean isAutoScheduled() {
            return this.autoScheduled;
        }

        public boolean isManualScheduled() {
            return this.manualScheduled;
        }

        public boolean isDir() {
            return this.dir;
        }

        public String getWarning() {
            return this.warning;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        public void setLastModifiedTime(long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public void setTimeLag(long timeLag) {
            this.timeLag = timeLag;
        }

        public void setBytesLag(long bytesLag) {
            this.bytesLag = bytesLag;
        }

        public void setFileSize(long fileSize) {
            this.fileSize = fileSize;
        }

        public void setSupport(boolean support) {
            this.support = support;
        }

        public void setAutoScheduled(boolean autoScheduled) {
            this.autoScheduled = autoScheduled;
        }

        public void setManualScheduled(boolean manualScheduled) {
            this.manualScheduled = manualScheduled;
        }

        public void setDir(boolean dir) {
            this.dir = dir;
        }

        public void setWarning(String warning) {
            this.warning = warning;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileStat)) {
                return false;
            }
            FileStat other = (FileStat)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLastModifiedTime() != other.getLastModifiedTime()) {
                return false;
            }
            if (this.getTimeLag() != other.getTimeLag()) {
                return false;
            }
            if (this.getBytesLag() != other.getBytesLag()) {
                return false;
            }
            if (this.getFileSize() != other.getFileSize()) {
                return false;
            }
            if (this.isSupport() != other.isSupport()) {
                return false;
            }
            if (this.isAutoScheduled() != other.isAutoScheduled()) {
                return false;
            }
            if (this.isManualScheduled() != other.isManualScheduled()) {
                return false;
            }
            if (this.isDir() != other.isDir()) {
                return false;
            }
            if (this.isActive() != other.isActive()) {
                return false;
            }
            String this$filePath = this.getFilePath();
            String other$filePath = other.getFilePath();
            if (this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath)) {
                return false;
            }
            String this$warning = this.getWarning();
            String other$warning = other.getWarning();
            return !(this$warning == null ? other$warning != null : !this$warning.equals(other$warning));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileStat;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $lastModifiedTime = this.getLastModifiedTime();
            result = result * 59 + (int)($lastModifiedTime >>> 32 ^ $lastModifiedTime);
            long $timeLag = this.getTimeLag();
            result = result * 59 + (int)($timeLag >>> 32 ^ $timeLag);
            long $bytesLag = this.getBytesLag();
            result = result * 59 + (int)($bytesLag >>> 32 ^ $bytesLag);
            long $fileSize = this.getFileSize();
            result = result * 59 + (int)($fileSize >>> 32 ^ $fileSize);
            result = result * 59 + (this.isSupport() ? 79 : 97);
            result = result * 59 + (this.isAutoScheduled() ? 79 : 97);
            result = result * 59 + (this.isManualScheduled() ? 79 : 97);
            result = result * 59 + (this.isDir() ? 79 : 97);
            result = result * 59 + (this.isActive() ? 79 : 97);
            String $filePath = this.getFilePath();
            result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
            String $warning = this.getWarning();
            result = result * 59 + ($warning == null ? 43 : $warning.hashCode());
            return result;
        }

        public String toString() {
            return "LogFileManager.FileStat(filePath=" + this.getFilePath() + ", lastModifiedTime=" + this.getLastModifiedTime() + ", timeLag=" + this.getTimeLag() + ", bytesLag=" + this.getBytesLag() + ", fileSize=" + this.getFileSize() + ", support=" + this.isSupport() + ", autoScheduled=" + this.isAutoScheduled() + ", manualScheduled=" + this.isManualScheduled() + ", dir=" + this.isDir() + ", warning=" + this.getWarning() + ", active=" + this.isActive() + ")";
        }
    }

    public static class FileManagerStat {
        private String managerId;
        private String logFilePath;
        private List<String> activeLogFiles;
        private List<FileStat> allLogFiles;

        public String getManagerId() {
            return this.managerId;
        }

        public String getLogFilePath() {
            return this.logFilePath;
        }

        public List<String> getActiveLogFiles() {
            return this.activeLogFiles;
        }

        public List<FileStat> getAllLogFiles() {
            return this.allLogFiles;
        }

        public void setManagerId(String managerId) {
            this.managerId = managerId;
        }

        public void setLogFilePath(String logFilePath) {
            this.logFilePath = logFilePath;
        }

        public void setActiveLogFiles(List<String> activeLogFiles) {
            this.activeLogFiles = activeLogFiles;
        }

        public void setAllLogFiles(List<FileStat> allLogFiles) {
            this.allLogFiles = allLogFiles;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileManagerStat)) {
                return false;
            }
            FileManagerStat other = (FileManagerStat)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$managerId = this.getManagerId();
            String other$managerId = other.getManagerId();
            if (this$managerId == null ? other$managerId != null : !this$managerId.equals(other$managerId)) {
                return false;
            }
            String this$logFilePath = this.getLogFilePath();
            String other$logFilePath = other.getLogFilePath();
            if (this$logFilePath == null ? other$logFilePath != null : !this$logFilePath.equals(other$logFilePath)) {
                return false;
            }
            List<String> this$activeLogFiles = this.getActiveLogFiles();
            List<String> other$activeLogFiles = other.getActiveLogFiles();
            if (this$activeLogFiles == null ? other$activeLogFiles != null : !((Object)this$activeLogFiles).equals(other$activeLogFiles)) {
                return false;
            }
            List<FileStat> this$allLogFiles = this.getAllLogFiles();
            List<FileStat> other$allLogFiles = other.getAllLogFiles();
            return !(this$allLogFiles == null ? other$allLogFiles != null : !((Object)this$allLogFiles).equals(other$allLogFiles));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileManagerStat;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $managerId = this.getManagerId();
            result = result * 59 + ($managerId == null ? 43 : $managerId.hashCode());
            String $logFilePath = this.getLogFilePath();
            result = result * 59 + ($logFilePath == null ? 43 : $logFilePath.hashCode());
            List<String> $activeLogFiles = this.getActiveLogFiles();
            result = result * 59 + ($activeLogFiles == null ? 43 : ((Object)$activeLogFiles).hashCode());
            List<FileStat> $allLogFiles = this.getAllLogFiles();
            result = result * 59 + ($allLogFiles == null ? 43 : ((Object)$allLogFiles).hashCode());
            return result;
        }

        public String toString() {
            return "LogFileManager.FileManagerStat(managerId=" + this.getManagerId() + ", logFilePath=" + this.getLogFilePath() + ", activeLogFiles=" + this.getActiveLogFiles() + ", allLogFiles=" + this.getAllLogFiles() + ")";
        }
    }

    public static class Lag {
        private long time;
        private long bytes;

        public long getTime() {
            return this.time;
        }

        public long getBytes() {
            return this.bytes;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public void setBytes(long bytes) {
            this.bytes = bytes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Lag)) {
                return false;
            }
            Lag other = (Lag)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTime() != other.getTime()) {
                return false;
            }
            return this.getBytes() == other.getBytes();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Lag;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $time = this.getTime();
            result = result * 59 + (int)($time >>> 32 ^ $time);
            long $bytes = this.getBytes();
            result = result * 59 + (int)($bytes >>> 32 ^ $bytes);
            return result;
        }

        public String toString() {
            return "LogFileManager.Lag(time=" + this.getTime() + ", bytes=" + this.getBytes() + ")";
        }
    }

    public static interface Config {
        default public int rolloverCheckCount() {
            return 3;
        }

        default public int watchTimeSec() {
            return 30;
        }
    }
}

