/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.kernel.shared.vfile;

import com.ovopark.kernel.shared.Model;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.vfile.Snapshot;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public interface FileIO
extends Snapshot {
    public FilePutResult put(String var1, Map<String, Object> var2, byte[] var3);

    public FilePutResult put(Map<String, Object> var1, byte[] var2);

    public CompareAndSetResult compareAndSet(String var1, CompareAndSet var2);

    public FileDeleteResult delete(String var1);

    public DiskFileStat diskFileStat();

    public void close() throws Exception;

    public static class FileStat
    implements Model {
        private long sumByteSize;
        private long sumValidByteSize;
        List<File> fileList = new ArrayList<File>();

        public long getSumByteSize() {
            return this.sumByteSize;
        }

        public long getSumValidByteSize() {
            return this.sumValidByteSize;
        }

        public List<File> getFileList() {
            return this.fileList;
        }

        public void setSumByteSize(long sumByteSize) {
            this.sumByteSize = sumByteSize;
        }

        public void setSumValidByteSize(long sumValidByteSize) {
            this.sumValidByteSize = sumValidByteSize;
        }

        public void setFileList(List<File> fileList) {
            this.fileList = fileList;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileStat)) {
                return false;
            }
            FileStat other = (FileStat)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSumByteSize() != other.getSumByteSize()) {
                return false;
            }
            if (this.getSumValidByteSize() != other.getSumValidByteSize()) {
                return false;
            }
            List<File> this$fileList = this.getFileList();
            List<File> other$fileList = other.getFileList();
            return !(this$fileList == null ? other$fileList != null : !((Object)this$fileList).equals(other$fileList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileStat;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $sumByteSize = this.getSumByteSize();
            result = result * 59 + (int)($sumByteSize >>> 32 ^ $sumByteSize);
            long $sumValidByteSize = this.getSumValidByteSize();
            result = result * 59 + (int)($sumValidByteSize >>> 32 ^ $sumValidByteSize);
            List<File> $fileList = this.getFileList();
            result = result * 59 + ($fileList == null ? 43 : ((Object)$fileList).hashCode());
            return result;
        }

        public String toString() {
            return "FileIO.FileStat(sumByteSize=" + this.getSumByteSize() + ", sumValidByteSize=" + this.getSumValidByteSize() + ", fileList=" + this.getFileList() + ")";
        }

        public static class File
        implements Model {
            private String name;
            private long lastModifiedTimeMs;
            private boolean valid;
            private long byteSize;
            private int shard;

            public String getName() {
                return this.name;
            }

            public long getLastModifiedTimeMs() {
                return this.lastModifiedTimeMs;
            }

            public boolean isValid() {
                return this.valid;
            }

            public long getByteSize() {
                return this.byteSize;
            }

            public int getShard() {
                return this.shard;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setLastModifiedTimeMs(long lastModifiedTimeMs) {
                this.lastModifiedTimeMs = lastModifiedTimeMs;
            }

            public void setValid(boolean valid) {
                this.valid = valid;
            }

            public void setByteSize(long byteSize) {
                this.byteSize = byteSize;
            }

            public void setShard(int shard) {
                this.shard = shard;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof File)) {
                    return false;
                }
                File other = (File)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.getLastModifiedTimeMs() != other.getLastModifiedTimeMs()) {
                    return false;
                }
                if (this.isValid() != other.isValid()) {
                    return false;
                }
                if (this.getByteSize() != other.getByteSize()) {
                    return false;
                }
                if (this.getShard() != other.getShard()) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                return !(this$name == null ? other$name != null : !this$name.equals(other$name));
            }

            protected boolean canEqual(Object other) {
                return other instanceof File;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                long $lastModifiedTimeMs = this.getLastModifiedTimeMs();
                result = result * 59 + (int)($lastModifiedTimeMs >>> 32 ^ $lastModifiedTimeMs);
                result = result * 59 + (this.isValid() ? 79 : 97);
                long $byteSize = this.getByteSize();
                result = result * 59 + (int)($byteSize >>> 32 ^ $byteSize);
                result = result * 59 + this.getShard();
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                return result;
            }

            public String toString() {
                return "FileIO.FileStat.File(name=" + this.getName() + ", lastModifiedTimeMs=" + this.getLastModifiedTimeMs() + ", valid=" + this.isValid() + ", byteSize=" + this.getByteSize() + ", shard=" + this.getShard() + ")";
            }
        }
    }

    public static interface DiskFileStat {
        public FileStat fileStat();

        default public void pretty(OutputStream outputStream) {
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);){
                this.pretty(outputStreamWriter);
            }
            catch (IOException e) {
                throw Util.convert2RuntimeException(e);
            }
        }

        public void pretty(OutputStreamWriter var1);
    }

    public static interface ShardFileIO
    extends FileIO {
        public FilePutResult put(String var1, Map<String, Object> var2, byte[] var3, Options var4);

        public FilePutResult put(Map<String, Object> var1, byte[] var2, Options var3);

        public CompareAndSetResult compareAndSet(String var1, CompareAndSet var2, Options var3);

        public FileGetResult get(String var1, Options var2);

        public FileDeleteResult delete(String var1, Options var2);

        public void search(SearchListener var1, Options var2);

        public List<FileGetResult> searchAfter(String var1, boolean var2, int var3, Options var4);

        public List<FileGetResult> searchAfter(String var1, boolean var2, int var3, Predicate<String> var4, Options var5);

        public List<FileGetResult> searchBefore(String var1, boolean var2, int var3, Options var4);

        public List<FileGetResult> searchBefore(String var1, boolean var2, int var3, Predicate<String> var4, Options var5);

        public List<FileGetResult> top(int var1, Options var2);

        public List<FileGetResult> tail(int var1, Options var2);

        public static class Options
        implements Model {
            String route;

            public static Options fromRoute(String route) {
                Options options = new Options();
                options.setRoute(route);
                return options;
            }

            public String getRoute() {
                return this.route;
            }

            public void setRoute(String route) {
                this.route = route;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Options)) {
                    return false;
                }
                Options other = (Options)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$route = this.getRoute();
                String other$route = other.getRoute();
                return !(this$route == null ? other$route != null : !this$route.equals(other$route));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Options;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $route = this.getRoute();
                result = result * 59 + ($route == null ? 43 : $route.hashCode());
                return result;
            }

            public String toString() {
                return "FileIO.ShardFileIO.Options(route=" + this.getRoute() + ")";
            }
        }
    }

    public static class NotSupportedFileIO
    implements FileIO {
        @Override
        public FilePutResult put(String key, Map<String, Object> meta, byte[] data) {
            throw new UnsupportedOperationException();
        }

        @Override
        public FilePutResult put(Map<String, Object> meta, byte[] data) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CompareAndSetResult compareAndSet(String key, CompareAndSet compareAndSet) {
            throw new UnsupportedOperationException();
        }

        @Override
        public FileGetResult get(String key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public FileGetResult get(String key, boolean fetchData) {
            throw new UnsupportedOperationException();
        }

        @Override
        public FileDeleteResult delete(String key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void search(SearchListener searchListener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<FileGetResult> searchAfter(String key, boolean inclusive, int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<FileGetResult> searchAfter(String key, boolean inclusive, int n, Predicate<String> predicate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<FileGetResult> searchBefore(String key, boolean inclusive, int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<FileGetResult> searchBefore(String key, boolean inclusive, int n, Predicate<String> predicate) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<FileGetResult> top(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<FileGetResult> tail(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int rowCountIncludeInvalidData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int count() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws Exception {
            throw new UnsupportedOperationException();
        }

        @Override
        public DiskFileStat diskFileStat() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface Setter {
    }

    public static interface Put
    extends Setter {
        public Put meta(Map<String, Object> var1);

        public Put data(byte[] var1);
    }

    public static interface Delete
    extends Setter {
    }

    public static interface Operator {
        public Setter noop();

        public Put update();

        public Delete delete();
    }

    public static interface CompareAndSet {
        public Setter test(FileGetResult var1, Operator var2);
    }

    public static interface CompareAndSetResult {
        public FilePutResult updated();

        public FileDeleteResult deleted();

        public boolean noop();
    }

    public static interface FileDeleteResult {
        public String key();

        default public long vcc() {
            return -1L;
        }
    }

    public static interface FilePutResult {
        public String key();

        default public long vcc() {
            return -1L;
        }
    }

    public static interface FileGetResult {
        public String key();

        public Map<String, Object> meta();

        public byte[] data();

        default public long vcc() {
            return -1L;
        }

        public String filePath();
    }

    public static interface SearchContext {
        public void cancel();
    }

    public static interface SearchListener {
        public void onRow(FileGetResult var1, SearchContext var2);
    }
}

