/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.kernel.shared;

import com.ovopark.kernel.shared.IVal;
import com.ovopark.kernel.shared.ServiceProvider;
import java.util.LinkedList;
import java.util.ServiceLoader;

public interface Config
extends IVal {

    public static class ConfigPriority
    implements Config {
        private static final LinkedList<Config> configList = new LinkedList();
        private static final ConfigPriority INSTANCE;

        private ConfigPriority() {
        }

        public static ConfigPriority option() {
            return INSTANCE;
        }

        @Override
        public Object getObject(String key, Object object) {
            for (Config config : configList) {
                if (!config.contains(key)) continue;
                return config.getObject(key, object);
            }
            return object;
        }

        public void takeHighPriority(Config config) {
            configList.addFirst(config);
        }

        @Override
        public boolean contains(String key) {
            for (Config config : configList) {
                if (!config.contains(key)) continue;
                return true;
            }
            return false;
        }

        static {
            ServiceLoader<ConfigProvider> serviceLoader = ServiceLoader.load(ConfigProvider.class);
            for (ConfigProvider cp : serviceLoader) {
                Config config = (Config)cp.get();
                configList.addLast(config);
            }
            configList.addLast(new SystemPropertyConfig());
            configList.addLast(new SystemEnvConfig());
            INSTANCE = new ConfigPriority();
        }
    }

    public static interface ConfigProvider
    extends ServiceProvider<Config> {
    }

    public static class SystemPropertyConfig
    implements Config {
        @Override
        public boolean contains(String key) {
            String property = System.getProperty(key);
            return property != null;
        }

        @Override
        public Object getObject(String key, Object object) {
            String property = System.getProperty(key);
            return property == null ? object : property;
        }
    }

    public static class SystemEnvConfig
    implements Config {
        @Override
        public boolean contains(String key) {
            String property = System.getenv(key);
            return property != null;
        }

        @Override
        public Object getObject(String key, Object object) {
            String property = System.getenv(key);
            return property == null ? object : property;
        }
    }
}

