/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.kernel.shared.topn;

import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.topn.TopN;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

class LinkedListTop
implements TopN {
    private final int top;
    private final LinkedList<TopN.TopElement> topElementList;
    private long ver;

    public LinkedListTop(int top) {
        this.top = top;
        this.topElementList = new LinkedList();
    }

    @Override
    public synchronized boolean push(String id, long time) {
        if (time <= 0L) {
            return false;
        }
        for (int i = this.topElementList.size() - 1; i >= 0; --i) {
            TopN.TopElement larger = this.topElementList.get(i);
            String elementId = larger.getElementId();
            if (Util.compare2((Comparable)((Object)id), (Comparable)((Object)elementId)) != 0) continue;
            return false;
        }
        int foundIndex = -1;
        for (int i = this.topElementList.size() - 1; i >= 0; --i) {
            TopN.TopElement larger = this.topElementList.get(i);
            long maxTime = larger.getTime();
            if (time > maxTime) {
                foundIndex = i;
                break;
            }
            long minTime = 0L;
            if (i - 1 >= 0) {
                minTime = this.topElementList.get(i - 1).getTime();
            }
            if (time > larger.getTime() || time <= minTime) continue;
            foundIndex = i - 1;
            break;
        }
        TopN.TopElement topElement = new TopN.TopElement();
        topElement.setElementId(id);
        topElement.setTime(time);
        if (this.topElementList.size() == this.top) {
            TopN.TopElement removeFirst;
            if (foundIndex == -1) {
                return false;
            }
            if (foundIndex == this.topElementList.size() - 1) {
                removeFirst = this.topElementList.removeFirst();
                this.topElementList.offer(topElement);
                ++this.ver;
            } else {
                removeFirst = this.topElementList.removeFirst();
                this.topElementList.add(foundIndex, topElement);
                ++this.ver;
            }
        } else if (foundIndex == -1) {
            this.topElementList.push(topElement);
            ++this.ver;
        } else {
            this.topElementList.add(foundIndex, topElement);
            ++this.ver;
        }
        return true;
    }

    @Override
    public synchronized boolean contains(String id) {
        for (int i = 0; i < this.topElementList.size(); ++i) {
            TopN.TopElement topElement = this.topElementList.get(i);
            if (Util.compare2((Comparable)((Object)topElement.getElementId()), (Comparable)((Object)id)) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized List<TopN.TopElement> top(int topSize) {
        int fixedSize = Math.min(topSize, this.size());
        ArrayList<TopN.TopElement> elementList = new ArrayList<TopN.TopElement>(fixedSize);
        for (int i = 0; i < fixedSize; ++i) {
            elementList.add(this.topElementList.get(i));
        }
        return elementList;
    }

    @Override
    public long updatedVer() {
        return this.ver;
    }

    @Override
    public int size() {
        return this.topElementList.size();
    }
}

