/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.kernel.shared.vclient;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.concurrent.ReleasableLock;
import com.ovopark.kernel.shared.vclient.Client2ServerTransport;
import com.ovopark.kernel.shared.vclient.JobLog;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobLogImpl
implements JobLog {
    private static final Logger log = LoggerFactory.getLogger(JobLogImpl.class);
    final ExecutorService jobLogExecutor;
    final Client2ServerTransport client2ServerTransport;
    final Queue<String> contentQueue;
    final String traceId;
    private volatile long lastSyncLogTimeMs = System.currentTimeMillis();
    private final ReentrantReadWriteLock dataReadWriteLock = new ReentrantReadWriteLock();
    private final ReleasableLock dataSLock = new ReleasableLock(this.dataReadWriteLock.readLock());
    private final ReleasableLock dataXLock = new ReleasableLock(this.dataReadWriteLock.writeLock());
    private volatile boolean closed;
    private final long taskId;
    private final String node;

    public JobLogImpl(ExecutorService jobLogExecutor, Client2ServerTransport client2ServerTransport, String traceId, long taskId, String node) {
        this.jobLogExecutor = jobLogExecutor;
        this.client2ServerTransport = client2ServerTransport;
        this.contentQueue = new ArrayBlockingQueue<String>(100);
        this.traceId = traceId;
        this.taskId = taskId;
        this.node = node;
    }

    @Override
    public void log(Supplier<String> content) {
        this.log(content.get());
    }

    @Override
    public void log(String content) {
        if (this.closed) {
            return;
        }
        String finalContent = this.traceId + " > " + content;
        if (this.contentQueue.offer(finalContent)) {
            long now = System.currentTimeMillis();
            if (now - this.lastSyncLogTimeMs > 1000L) {
                this.fsync0(false, false);
            }
        } else {
            this.fsync0(false, false);
            this.contentQueue.offer(finalContent);
        }
    }

    @Override
    public void flush() {
        this.fsync0(false, false);
    }

    @Override
    public void flush(boolean sync) {
        this.fsync0(false, sync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fsync0(boolean closed, boolean sync) {
        this.dataXLock.acquire();
        try {
            ArrayList<String> list = new ArrayList<String>(this.contentQueue.size());
            list.addAll(this.contentQueue);
            Client2ServerTransport.TaskLogRequest taskLogRequest = new Client2ServerTransport.TaskLogRequest();
            taskLogRequest.setLogList(list);
            taskLogRequest.setNode(this.node);
            taskLogRequest.setTaskId(this.taskId);
            this.contentQueue.clear();
            this.lastSyncLogTimeMs = System.currentTimeMillis();
            Runnable command = Util.catchRunnable(() -> {
                Client2ServerTransport.TaskLogResponse taskLogResponse = this.client2ServerTransport.log(taskLogRequest);
                log.info("sync log success: " + JSONAccessor.impl().format(taskLogResponse));
            });
            if (sync) {
                command.run();
            } else {
                this.jobLogExecutor.execute(command);
            }
        }
        finally {
            if (closed) {
                this.closed = true;
            }
            this.dataXLock.unlock();
        }
    }

    @Override
    public void close() {
        this.fsync0(true, true);
    }
}

