package com.ovopark.module.shared.jdk8.rbac;



import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.module.shared.jdk8.JavaxFilterChain;
import com.ovopark.module.shared.jdk8.JavaxServletRequest;
import com.ovopark.module.shared.jdk8.JavaxServletResponse;
import com.ovopark.module.shared.spring.rbac.SessionClientResource;
import com.ovopark.module.shared.spring.rbac.SessionService;
import com.ovopark.module.shared.spring.rbac.TokenHandler;
import lombok.extern.slf4j.Slf4j;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

@Slf4j
public class Jdk8SessionFilter extends com.ovopark.module.shared.spring.rbac.SessionFilter<HttpServletRequest, HttpServletResponse> implements Filter {


    public Jdk8SessionFilter(SessionService.SessionServiceProvider serviceProvider
            , JSONAccessor jsonAccessor, TokenHandler tokenHandler, SessionClientResource sessionClientResource) {
        super(serviceProvider, jsonAccessor,tokenHandler,sessionClientResource);
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        JavaxServletRequest javaxServletRequest = new JavaxServletRequest(request);
        JavaxServletResponse javaxServletResponse = new JavaxServletResponse(response);
        super.doFilter(javaxServletRequest,javaxServletResponse,new JavaxFilterChain(chain));
    }

}
