package com.ovopark.module.shared.jdk8;

import com.ovopark.module.shared.spring.ResourceAccess;
import com.ovopark.module.shared.spring.SharedRequest;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class JavaxServletRequest implements SharedRequest<HttpServletRequest> {

    final private HttpServletRequest request;

    public JavaxServletRequest(ServletRequest request) {
        this((HttpServletRequest) request);
    }

    public JavaxServletRequest(HttpServletRequest request) {
        this.request = request;
    }


    @Override
    public String getServletPath() {
        return request.getServletPath();
    }

    @Override
    public String getHeader(String name) {
        return request.getHeader(name);
    }

    @Override
    public HttpServletRequest request() {
        return request;
    }


    static boolean isFromWAN(ServletRequest request){
        return ResourceAccess.getOrCreate().isFromWAN(new JavaxServletRequest(request));
    }

    @Override
    public String getRemoteAddr() {
        return request.getRemoteAddr();
    }
}
