package com.ovopark.module.shared.jdk8;

import com.ovopark.module.shared.spring.SharedFilterChain;
import com.ovopark.module.shared.spring.SharedRequest;
import com.ovopark.module.shared.spring.SharedResponse;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

import static com.ovopark.kernel.shared.Util.convert2RuntimeException;

public class JavaxFilterChain implements SharedFilterChain<HttpServletRequest, HttpServletResponse> {

    final FilterChain filterChain;

    public JavaxFilterChain(FilterChain filterChain) {
        this.filterChain = filterChain;
    }

    @Override
    public void doFilter(SharedRequest<HttpServletRequest> request, SharedResponse<HttpServletResponse> response) {
        try {
            filterChain.doFilter(request.request(), response.response());
        } catch (IOException | ServletException e) {
            throw convert2RuntimeException(e);
        }
    }
}
