package com.ovopark.module.shared.jdk8.rbac;

import com.ovopark.module.shared.jdk8.JavaxFilterChain;
import com.ovopark.module.shared.jdk8.JavaxServletRequest;
import com.ovopark.module.shared.jdk8.JavaxServletResponse;
import com.ovopark.module.shared.spring.rbac.LANAccessHandler;
import com.ovopark.module.shared.spring.rbac.LANResource;
import com.ovopark.module.shared.spring.rbac.SessionClient;
import com.ovopark.module.shared.spring.rbac.TokenHandler;
import lombok.extern.slf4j.Slf4j;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

@Slf4j
public class Jdk8ResourceFilter extends com.ovopark.module.shared.spring.rbac.ResourceFilter
        <HttpServletRequest, HttpServletResponse> implements Filter {

    public Jdk8ResourceFilter(LANResource lanResource, LANAccessHandler lanAccessHandler, SessionClient sessionClient, TokenHandler tokenHandler) {
        super(lanResource, lanAccessHandler,sessionClient,tokenHandler);
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        JavaxServletRequest javaxServletRequest = new JavaxServletRequest(servletRequest);
        JavaxServletResponse javaxServletResponse = new JavaxServletResponse(servletResponse);
        super.doFilter(javaxServletRequest,javaxServletResponse,new JavaxFilterChain(filterChain));
    }

}
