package com.ovopark.module.shared.jdk8.rbac;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;

import java.util.Map;

public class Jdk8SessionRegister implements ImportBeanDefinitionRegistrar, ResourceLoaderAware, EnvironmentAware {

    private ResourceLoader resourceLoader;

    private Environment environment;


    @Override
    public void setEnvironment(Environment environment) {
        this.environment=environment;
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader=resourceLoader;
    }

    @Override
    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {

        Map<String, Object> annotationAttributes = metadata.getAnnotationAttributes(EnableSessionClient.class.getName(), true);

        Boolean filter = (Boolean) annotationAttributes.get("filter");

        BeanDefinitionBuilder builder;

        if (filter) {
            builder = BeanDefinitionBuilder.genericBeanDefinition(Jdk8SessionConfig.class);
            builder.setLazyInit(true);
            registry.registerBeanDefinition(Jdk8SessionConfig.class.getName(),
                    builder.getBeanDefinition());
        }

    }
}
