package com.ovopark.module.shared.jdk8.rbac;


import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.module.shared.spring.BeanOrder;
import com.ovopark.module.shared.spring.rbac.SessionClientResource;
import com.ovopark.module.shared.spring.rbac.SessionFilter;
import com.ovopark.module.shared.spring.rbac.SessionService;
import com.ovopark.module.shared.spring.rbac.TokenHandler;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;

public class Jdk8SessionConfig {

    @Bean
    public Jdk8SessionFilter jdk8SessionFilter(
            SessionService.SessionServiceProvider serviceProvider
            , JSONAccessor jsonAccessor
            , TokenHandler tokenHandler
            , SessionClientResource sessionClientResource
    ){
        return new Jdk8SessionFilter(serviceProvider,jsonAccessor,tokenHandler,sessionClientResource);
    }

    @Bean
    public FilterRegistrationBean<Jdk8SessionFilter> sessionFilterFilterRegistrationBean(
            Jdk8SessionFilter jdk8SessionFilter
    ) {
        FilterRegistrationBean<Jdk8SessionFilter> registration = new FilterRegistrationBean<Jdk8SessionFilter>();
        registration.setFilter(jdk8SessionFilter);
        registration.addUrlPatterns("/*");
        registration.setName(SessionFilter.class.getName());
        registration.setOrder(BeanOrder.SESSION);
        return registration;
    }



}
