package com.ovopark.module.shared.jdk8.rbac;

import com.ovopark.module.shared.spring.BeanOrder;
import com.ovopark.module.shared.spring.rbac.LANAccessHandler;
import com.ovopark.module.shared.spring.rbac.LANResource;
import com.ovopark.module.shared.spring.rbac.SessionClient;
import com.ovopark.module.shared.spring.rbac.TokenHandler;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;

public class Jdk8LANConfig {

    @Bean
    public FilterRegistrationBean<Jdk8ResourceFilter> resourceFilterFilterRegistrationBean(
            LANResource lanResource
            , LANAccessHandler lanAccessHandler
            , SessionClient sessionClient
            , TokenHandler tokenHandler
    ) {
        FilterRegistrationBean<Jdk8ResourceFilter> registration = new FilterRegistrationBean<Jdk8ResourceFilter>();
        registration.setFilter(new Jdk8ResourceFilter(lanResource,lanAccessHandler,sessionClient,tokenHandler));
        registration.addUrlPatterns("/*");
        registration.setName("ResourceFilter");
        registration.setOrder(BeanOrder.LAN);
        return registration;
    }

}
