package com.ovopark.module.shared.jdk8;

import com.ovopark.module.shared.spring.SharedResponse;

import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;

public class JavaxServletResponse implements SharedResponse<HttpServletResponse> {

    final private HttpServletResponse response;

    public JavaxServletResponse(HttpServletResponse response) {
        this.response = response;
    }

    public JavaxServletResponse(ServletResponse response) {
        this.response = ((HttpServletResponse) response);
    }

    @Override
    public HttpServletResponse response() {
        return response;
    }

    @Override
    public void setHeader(String name, String value) {
        response.setHeader(name,value);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return response.getOutputStream();
    }

    @Override
    public void setContentType(String contentType) {
        response.setContentType(contentType);
    }
}
