package com.ovopark.module.shared.redis;

import org.redisson.api.RRateLimiter;
import org.redisson.api.RateIntervalUnit;
import org.redisson.api.RateType;

import java.util.concurrent.TimeUnit;

public class RedisRateLimiter implements RateLimiter{

    private final String name;

    final private RRateLimiter rateLimiter;

    final RateLimiterConf rateLimiterConf;

    public RedisRateLimiter(String name, RRateLimiter rateLimiter,RateLimiterConf rateLimiterConf) {
        this.name = name;
        this.rateLimiter = rateLimiter;
        this.rateLimiterConf=rateLimiterConf;
    }


    boolean trySetRate(long rate, long rateInterval, TimeUnit rateIntervalUnit) {
        return rateLimiter.trySetRate(RateType.OVERALL,rate
                ,TimeUnit.MILLISECONDS.convert(rateInterval,rateIntervalUnit)
                , RateIntervalUnit.MILLISECONDS);
    }

    void setRate(long rate, long rateInterval, TimeUnit rateIntervalUnit) {
        rateLimiter.setRate(RateType.OVERALL,rate
                ,TimeUnit.MILLISECONDS.convert(rateInterval,rateIntervalUnit)
                , RateIntervalUnit.MILLISECONDS);
    }

    @Override
    public boolean tryAcquire(long permits, long timeout, TimeUnit unit) {

        if (permits >rateLimiterConf.getRate()) {
            throw new IllegalArgumentException("Requested permits amount could not exceed defined rate: "+rateLimiterConf.getRate()+" < "+permits);
        }

        return rateLimiter.tryAcquire(permits,timeout,unit);
    }

    @Override
    public boolean tryAcquire(long timeout, TimeUnit unit) {
        return tryAcquire(1,timeout,unit);
    }

    @Override
    public boolean tryAcquire(long permits) {

        if (permits >rateLimiterConf.getRate()) {
            throw new IllegalArgumentException("Requested permits amount could not exceed defined rate: "+rateLimiterConf.getRate()+" < "+permits);
        }
        return rateLimiter.tryAcquire(permits);
    }

    @Override
    public String name() {
        return name;
    }

    @Override
    public void acquire() {
        rateLimiter.acquire();
    }

    @Override
    public void acquire(long permits) {
        if (permits >rateLimiterConf.getRate()) {
            throw new IllegalArgumentException("Requested permits amount could not exceed defined rate: "+rateLimiterConf.getRate()+" < "+permits);
        }
        rateLimiter.acquire(permits);
    }

    @Override
    public void close() throws Exception {

    }
}
