package com.ovopark.module.shared.spring.rbac;

import com.ovopark.kernel.shared.CacheStat;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.module.shared.Session;
import com.ovopark.module.shared.spring.FunctionRegister;
import com.ovopark.module.shared.spring.InfoCollector;
import com.ovopark.module.shared.spring.ResourceAccess;
import com.ovopark.module.shared.spring.SharedRequest;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

@Slf4j
public class SessionClientImpl implements SessionClient , FunctionRegister {


    @Autowired
    private SessionService.SessionServiceProvider serviceProvider;

    @Autowired
    private JSONAccessor jsonAccessor;

    public static final CacheStat cacheStat=CacheStat.cacheStat();

    @Override
    public Session session(SharedRequest<?> request) throws TokenInvalidException,TokenRefreshException,TokenRefreshExpiredException{

        //THREAD LOCAL
        Session session = Session.getOrCreate().get();
        if (session!=null) {
            return session;
        }

        //FROM GATEWAY
        session=ResourceAccess.getOrCreate().session(request,jsonAccessor);
        if (session!=null) {
            long l = cacheStat.hit();
            if (l %100==0) {
                InfoCollector.getOrCreate().put("SESSION_CLIENT_GATEWAY_TOKEN_HIT_COUNT",String.valueOf(l));
            }
            return session;
        }

        long l = cacheStat.miss();
        if (l %100==0) {
            InfoCollector.getOrCreate().put("SESSION_CLIENT_GATEWAY_TOKEN_MISS_COUNT",String.valueOf(l));
        }

        //FROM REQUEST HEAD
        return ResourceAccess.getOrCreate().session(request, serviceProvider);

    }

    @Override
    public void register() {
        log.info("SESSION_CLIENT_ENABLED > true");
        InfoCollector.getOrCreate().put("SESSION_CLIENT_ENABLED","true");
    }
}
