package com.ovopark.module.shared.spring.rbac;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.module.shared.spring.MapStructProxy;
import com.ovopark.privilege.pojo.UsersPojo;
import com.ovopark.sso.api.TokenApi;
import com.ovopark.sso.model.BaseResult;
import com.ovopark.sso.model.TokenValue;
import feign.Request;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

@Slf4j
public class SessionServiceFeignImpl implements SessionService {


    @Autowired
    private TokenApi tokenApi;


    @Autowired
    private com.ovopark.privilege.api.UserApi userApi;

    final private SessionStruct sessionStruct = MapStructProxy.getMapper(SessionStruct.class);

    @Autowired
    private JSONAccessor jsonAccessor;

    @Override
    public SessionToken parseNewToken(String newToken) throws TokenRefreshException,TokenInvalidException,TokenRefreshExpiredException{
        com.ovopark.sso.model.BaseResult<TokenValue> responseEntity = tokenApi.parseToken(newToken, new Request.Options());
        return parseToken0(newToken, responseEntity);
    }

    private SessionToken parseToken0(String newToken, BaseResult<TokenValue> responseEntity) {
        if (responseEntity == null || responseEntity.getIsError() || responseEntity.getData() == null) {
            log.warn("调用sso失败 {}", newToken);
            if (responseEntity != null && responseEntity.getIsError() ) {

                if (Cons.TOKEN_NOT_EXIT.equals(responseEntity.getCode())) {
                    throw new TokenInvalidException();
                }

                if (Cons.TOKEN_EXPIRATION.equals(responseEntity.getCode())) {
                    throw new TokenRefreshException();
                }

                if (Cons.TOKEN_REFRESH_EXPIRATION.equals(responseEntity.getCode())
                        || Cons.TOKEN_REFRESH_EXPIRATION_OPTIONAL_2.equals(responseEntity.getCode())
                ) {
                    throw new TokenRefreshExpiredException();
                }
                log.warn("调用sso失败 {}", jsonAccessor.format(responseEntity));
            }

            return null;
        }
        TokenValue data = responseEntity.getData();
//        SessionToken sessionToken=new SessionToken();
//        sessionToken.setToken(data.getToken());
//        sessionToken.setGroupId(data.getGroupId());
//        sessionToken.setIsAgency(data.getIsAgency());
//        sessionToken.setLoginType(data.getLoginType());
//        sessionToken.setTokenExpirationTimestamp(data.getTokenExpirationTimestamp());
//        sessionToken.setCreateAtTimestamp(data.getCreateAtTimestamp());
//        sessionToken.setIsAccountUser(data.getIsAccountUser());
//        sessionToken.setRefreshExpirationSurplusTimestamp(data.getRefreshExpirationSurplusTimestamp());
//        sessionToken.setRefreshExpirationTimestamp(data.getRefreshExpirationTimestamp());
//        sessionToken.setUserId(data.getUserId());
//        sessionToken.setUserName(data.getUserName());
        return sessionStruct.of(data);
    }

    @Override
    public SessionToken parseAccessToken(String accessToken) throws TokenRefreshException, TokenInvalidException, TokenRefreshExpiredException {
        com.ovopark.sso.model.BaseResult<TokenValue> responseEntity = tokenApi.parseMcpToken(accessToken, new Request.Options());
        return parseToken0(accessToken, responseEntity);
    }

    @Override
    public SessionUsersPojo getUsersById(Integer userId) {
        com.ovopark.privilege.response.BaseResult<com.ovopark.privilege.pojo.UsersPojo> baseResult = userApi.getUsersById(userId);
        if (!baseResult.getIsError()) {
            UsersPojo data = baseResult.getData();
//            SessionUsersPojo sessionUsersPojo=new SessionUsersPojo();
//            sessionUsersPojo.setUserName(data.getUserName());
//            sessionUsersPojo.setCreater(data.getCreater());
//            sessionUsersPojo.setDingdingUserId(data.getDingdingUserId());
//            sessionUsersPojo.setGroupId(data.getGroupId());
//            sessionUsersPojo.setId(data.getId());
//            sessionUsersPojo.setDingdingUserId(data.getDingdingUserId());
//            sessionUsersPojo.setActivateCode(data.getActivateCode());
//            sessionUsersPojo.setCreaterId(data.getCreaterId());
//            sessionUsersPojo.setDeptIds(data.getDeptIds());
            return sessionStruct.of(data);
        }
        return null;
    }
}
