/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.module.shared.spring.rbac;

import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.Session;
import com.ovopark.module.shared.spring.ResourceAccess;
import com.ovopark.module.shared.spring.SharedFilter;
import com.ovopark.module.shared.spring.SharedFilterChain;
import com.ovopark.module.shared.spring.SharedRequest;
import com.ovopark.module.shared.spring.SharedResponse;
import com.ovopark.module.shared.spring.rbac.LANAccessHandler;
import com.ovopark.module.shared.spring.rbac.LANResource;
import com.ovopark.module.shared.spring.rbac.SessionClient;
import com.ovopark.module.shared.spring.rbac.TokenHandler;
import com.ovopark.module.shared.spring.rbac.TokenInvalidException;
import com.ovopark.module.shared.spring.rbac.TokenRefreshException;
import com.ovopark.module.shared.spring.rbac.TokenRefreshExpiredException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

public class ResourceFilter<RQ, RS>
implements SharedFilter<RQ, RS> {
    private static final Logger log = LoggerFactory.getLogger(ResourceFilter.class);
    final LANResource lanResource;
    final LANAccessHandler lanAccessHandler;
    final SessionClient sessionClient;
    final TokenHandler tokenHandler;

    public ResourceFilter(LANResource lanResource, LANAccessHandler lanAccessHandler, SessionClient sessionClient, TokenHandler tokenHandler) {
        this.lanResource = lanResource;
        this.lanAccessHandler = lanAccessHandler;
        this.sessionClient = sessionClient;
        this.tokenHandler = tokenHandler;
    }

    @Override
    public void doFilter(SharedRequest<RQ> request, SharedResponse<RS> response, SharedFilterChain<RQ, RS> filterChain) {
        if (this.lanResource.off()) {
            filterChain.doFilter(request, response);
            return;
        }
        if (ResourceAccess.getOrCreate().isFromWAN(request) && this.lanResource.lanUrl() != null) {
            AntPathMatcher antPathMatcher = new AntPathMatcher();
            for (String url : this.lanResource.lanUrl()) {
                Session session;
                String servletPath;
                if (!antPathMatcher.match(url, servletPath = request.getServletPath())) continue;
                try {
                    session = this.sessionClient.session(request);
                }
                catch (Exception e) {
                    if (e instanceof TokenInvalidException) {
                        this.tokenHandler.handleInvalid(request, response);
                        return;
                    }
                    if (e instanceof TokenRefreshException) {
                        this.tokenHandler.handleRefresh(request, response);
                        return;
                    }
                    if (e instanceof TokenRefreshExpiredException) {
                        this.tokenHandler.handleRefreshExpired(request, response);
                        return;
                    }
                    throw Util.convert2RuntimeException((Throwable)e);
                }
                if (session != null) break;
                log.info("request from wan/internet cannot access lan service: " + servletPath + ", pattern: " + url);
                LANAccessHandler.Result result = this.lanAccessHandler.handle(request, response);
                if (result == LANAccessHandler.Result.STOP) {
                    return;
                }
                if (result != LANAccessHandler.Result.CONTINUE) continue;
                filterChain.doFilter(request, response);
                return;
            }
        }
        filterChain.doFilter(request, response);
    }
}

