package com.ovopark.module.shared.spring;

import com.ovopark.kernel.shared.kv.CacheService;
import org.bouncycastle.pqc.crypto.newhope.NHSecretKeyProcessor;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

final public class InfoCollector {

    CacheService<String,String> cache=new CacheService.MapCacheService<>(false);

    private static final InfoCollector INSTANCE=new InfoCollector();

    private InfoCollector() {
    }

    public static InfoCollector getOrCreate(){
        return INSTANCE;
    }

    public void put(String key,String value){
        Objects.requireNonNull(key);
        cache.set(key,value);
    }

    public String get(String key){
        return cache.get(key);
    }

    public void forEach(BiConsumer<String,String> infoConsumer){
        cache.forEach(infoConsumer);
    }



}
