/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.module.shared.spring.rbac;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.BaseResult;
import com.ovopark.module.shared.Session;
import com.ovopark.module.shared.spring.InfoCollector;
import com.ovopark.module.shared.spring.ResourceAccess;
import com.ovopark.module.shared.spring.SharedFilter;
import com.ovopark.module.shared.spring.SharedFilterChain;
import com.ovopark.module.shared.spring.SharedRequest;
import com.ovopark.module.shared.spring.SharedResponse;
import com.ovopark.module.shared.spring.rbac.SessionClientImpl;
import com.ovopark.module.shared.spring.rbac.SessionClientResource;
import com.ovopark.module.shared.spring.rbac.SessionService;
import com.ovopark.module.shared.spring.rbac.TokenHandler;
import com.ovopark.module.shared.spring.rbac.TokenInvalidException;
import com.ovopark.module.shared.spring.rbac.TokenRefreshException;
import com.ovopark.module.shared.spring.rbac.TokenRefreshExpiredException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

public class SessionFilter<RQ, RS>
implements SharedFilter<RQ, RS> {
    private static final Logger log = LoggerFactory.getLogger(SessionFilter.class);
    final SessionService.SessionServiceProvider serviceProvider;
    final JSONAccessor jsonAccessor;
    final TokenHandler tokenHandler;
    final SessionClientResource sessionClientResource;

    public SessionFilter(SessionService.SessionServiceProvider serviceProvider, JSONAccessor jsonAccessor, TokenHandler tokenHandler, SessionClientResource sessionClientResource) {
        this.serviceProvider = serviceProvider;
        this.jsonAccessor = jsonAccessor;
        this.tokenHandler = tokenHandler;
        this.sessionClientResource = sessionClientResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void doFilter(SharedRequest<RQ> request, SharedResponse<RS> response, SharedFilterChain<RQ, RS> filterChain) {
        block21: {
            if (this.sessionClientResource.off()) {
                filterChain.doFilter(request, response);
                return;
            }
            if (this.sessionClientResource.excludeUrl() != null) {
                AntPathMatcher antPathMatcher = new AntPathMatcher();
                for (String url : this.sessionClientResource.excludeUrl()) {
                    String servletPath;
                    if (!antPathMatcher.match(url, servletPath = request.getServletPath())) continue;
                    filterChain.doFilter(request, response);
                    return;
                }
            }
            try {
                Session session;
                block22: {
                    long l;
                    session = ResourceAccess.getOrCreate().session(request, this.jsonAccessor);
                    if (session != null && (l = SessionClientImpl.cacheStat.hit()) % 100L == 0L) {
                        InfoCollector.getOrCreate().put("SESSION_CLIENT_GATEWAY_TOKEN_HIT_COUNT", String.valueOf(l));
                    }
                    if (session != null) break block22;
                    l = SessionClientImpl.cacheStat.miss();
                    if (l % 100L == 0L) {
                        InfoCollector.getOrCreate().put("SESSION_CLIENT_GATEWAY_TOKEN_MISS_COUNT", String.valueOf(l));
                    }
                    try {
                        session = ResourceAccess.getOrCreate().session(request, this.serviceProvider);
                    }
                    catch (Exception e) {
                        block20: {
                            block19: {
                                if (e instanceof TokenInvalidException) {
                                    this.tokenHandler.handleInvalid(request, response);
                                    Session.getOrCreate().remove();
                                    return;
                                }
                                if (!(e instanceof TokenRefreshException)) break block19;
                                this.tokenHandler.handleRefresh(request, response);
                                Session.getOrCreate().remove();
                                return;
                            }
                            if (!(e instanceof TokenRefreshExpiredException)) break block20;
                            this.tokenHandler.handleRefreshExpired(request, response);
                            Session.getOrCreate().remove();
                            return;
                        }
                        try {
                            throw e;
                        }
                        catch (Exception e2) {
                            response.setContentType("application/json;charset=utf-8");
                            try {
                                response.getOutputStream().write(Util.utf8((String)this.jsonAccessor.format((Object)BaseResult.invalidToken())));
                            }
                            catch (IOException ex) {
                                throw new RuntimeException(ex);
                            }
                            return;
                        }
                    }
                }
                Session.getOrCreate().set(session);
                filterChain.doFilter(request, response);
                break block21;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Session.getOrCreate().remove();
            }
        }
    }
}

