package com.ovopark.module.shared.spring;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;

import java.util.List;

import static com.ovopark.kernel.shared.Util.isEmpty;

public class FunctionRegisterInSpring implements CommandLineRunner {


    private List<FunctionRegister> functionRegisterList;

    @Autowired
    public void setFunctionRegisterList(List<FunctionRegister> functionRegisterList) {
        this.functionRegisterList = functionRegisterList;
    }

    @Override
    public void run(String... args) throws Exception {
        if (isEmpty(functionRegisterList)) {
            return;
        }

        for (FunctionRegister functionRegister : functionRegisterList) {
            functionRegister.register();
        }

    }
}
