package com.ovopark.module.shared.spring;

import com.ovopark.kernel.shared.Processing;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.BaseResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

import static com.ovopark.kernel.shared.Util.isNotEmpty;

@Slf4j
@RestController("com.ovopark.module.shared.spring.ProcessingEndpoint")
@RequestMapping("/module-shared/processing")
public class ProcessingEndpoint {



    @GetMapping("/get")
    @ResponseBody
    public BaseResult get(@RequestParam("id") String id){
        Processing processing = Processing.get(id);
        Map<String, Object> map=new LinkedHashMap<>();
        if (processing != null) {
            map.put("tag",processing.tag());
            map.put("link",processing.link());
            List<String> list=new ArrayList<>();
            processing.forEach(s -> {
                if (isNotEmpty(s)) {
                    list.add(s);
                }
            });
            map.put("trace",list);
        }
        return BaseResult.success(map);
    }

    @GetMapping("/count")
    @ResponseBody
    public BaseResult count(){
        int count = Processing.count();
        return BaseResult.success(count);
    }

}
