package com.ovopark.module.shared.spring.rbac;

import com.ovopark.module.shared.Session;
import lombok.Data;

@Data
public class SessionImpl implements Session {

    private String backendToken;

    UserInfo userInfo;
    
    ClientInfo clientInfo;

    private boolean mcp;

    @Override
    public Integer getIsAgency() {
        return userInfo.getIsAgency();
    }

    @Override
    public int isAccountUser() {
        return userInfo.getIsAccountUser();
    }

    @Override
    public Integer getUserId() {
        return userInfo.getUserId();
    }

    @Override
    public String getUserName() {
        return userInfo.getUserName();
    }

    @Override
    public Integer getGroupId() {
        return userInfo.getGroupId();
    }

    @Override
    public com.ovopark.module.shared.ClientInfo clientInfo() {
        return clientInfo;
    }

    @Override
    public String backendToken() {
        return backendToken;
    }

    public boolean isMcp(){
        return mcp;
    }

}
