package com.ovopark.module.shared.spring;

import com.ovopark.module.shared.BaseResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

@Slf4j
@RestController("com.ovopark.module.shared.spring.InfoEndpoint")
@RequestMapping("/module-shared/info")
public class InfoEndpoint {

    @GetMapping("/seek")
    @ResponseBody
    public BaseResult<String> seek(@RequestParam("id")  String id){
        String str = InfoCollector.getOrCreate().get(id);
        return BaseResult.success(str);
    }

    @GetMapping("/all")
    @ResponseBody
    public BaseResult<List<String>> all(){
        List<String> allInfos=new ArrayList<>();
        InfoCollector.getOrCreate().forEach((k,v)->allInfos.add(k+" > "+v));
        allInfos.sort(Comparator.naturalOrder());
        return BaseResult.success(allInfos);
    }

}
