/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.shopweb.exception;

import com.ovopark.shopweb.exception.ErrorMessage;
import com.ovopark.shopweb.exception.ResultCodeInfo;
import com.ovopark.shopweb.exception.SysErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class Validation {
    private List<ErrorMessage> errorList = new ArrayList<ErrorMessage>();

    public static Validation newValidation() {
        return new Validation();
    }

    public Validation() {
    }

    public Validation(ResultCodeInfo error, Object ... msgs) {
        this.errorList.add(new ErrorMessage(error, msgs));
    }

    public Validation addError(ResultCodeInfo error, Object ... msgs) {
        this.errorList.add(new ErrorMessage(error, msgs));
        return this;
    }

    public Validation addError(Boolean isAddToErrorList, ResultCodeInfo error, Object ... msgs) {
        if (isAddToErrorList.booleanValue()) {
            this.errorList.add(new ErrorMessage(error, msgs));
        }
        return this;
    }

    public Validation addError(ResultCodeInfo error) {
        this.errorList.add(new ErrorMessage(error));
        return this;
    }

    public Validation addError(Validation v) {
        for (ErrorMessage em : v.errorList) {
            this.errorList.add(em);
        }
        return this;
    }

    public boolean isValid() {
        return this.errorList.size() == 0;
    }

    public void isValidThrowException() {
        if (!this.isValid()) {
            throw new SysErrorException(this);
        }
    }

    public String getErrorMsg() {
        if (null == this.errorList || 0 >= this.errorList.size()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (ErrorMessage error : this.errorList) {
            if (null == error.getMsgs() || error.getMsgs().length <= 0) {
                builder.append(error.getError().getDesc() + ",");
                continue;
            }
            builder.append(String.format(error.getError().getDesc(), error.getMsgs()) + ",");
        }
        if (builder.length() > 0) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    public Integer getErrorCode() {
        if (null == this.errorList || 0 >= this.errorList.size()) {
            return -1;
        }
        return this.errorList.get(0).getError().getCode();
    }

    public static boolean isInteger(String str) {
        return str != null && Pattern.matches("^\\d+$", str);
    }

    public static boolean isNumber(String str) {
        return str != null && Pattern.matches("^\\d+(.\\d+)?$", str);
    }
}

