/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.shopweb.utils;

import java.math.BigDecimal;
import java.util.Random;

public class ArithUtils {
    private static final int DEF_DIV_SCALE = 10;

    public static double add(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.add(b2).doubleValue();
    }

    public static double sub(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.subtract(b2).doubleValue();
    }

    public static double mul(double v1, double v2) {
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.multiply(b2).doubleValue();
    }

    public static double div(double v1, double v2) {
        return ArithUtils.div(v1, v2, 10);
    }

    public static double div(double v1, double v2, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b1 = new BigDecimal(Double.toString(v1));
        BigDecimal b2 = new BigDecimal(Double.toString(v2));
        return b1.divide(b2, scale, 4).doubleValue();
    }

    public static double round(double v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal b = new BigDecimal(Double.toString(v));
        BigDecimal one = new BigDecimal("1");
        return b.divide(one, scale, 4).doubleValue();
    }

    public static int mulDouble2Int(double v1, double v2, int scale) {
        BigDecimal big1 = new BigDecimal(Double.toString(v1)).setScale(scale, 4);
        BigDecimal big2 = new BigDecimal(Double.toString(v2));
        return big1.multiply(big2).intValue();
    }

    public int round(int i1, int i2) {
        int modi = 0;
        modi = i1 % i2;
        int i = i1 / i2;
        if (modi == 0) {
            return i;
        }
        return i + 1;
    }

    public int pow(int i1, int i2) {
        double d1 = i1;
        double d2 = i2;
        return (int)Math.pow(d1, d2);
    }

    public static int[] getSequence(int maxnum) {
        int[] sequence = new int[maxnum];
        for (int i = 0; i < maxnum; ++i) {
            sequence[i] = i;
        }
        Random random = new Random();
        for (int i = 0; i < maxnum; ++i) {
            int p = random.nextInt(maxnum);
            int tmp = sequence[i];
            sequence[i] = sequence[p];
            sequence[p] = tmp;
        }
        random = null;
        return sequence;
    }

    public static void main(String[] args) {
        double a = 0.019776;
        double round = ArithUtils.round(a, 3);
        System.err.println(round);
    }
}

