/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.check.core.calculator;

import cn.hutool.core.collection.CollectionUtil;
import com.ovopark.check.core.calculator.CustomScoreCalculator;
import com.ovopark.check.core.calculator.FinalSideEffect;
import com.ovopark.check.core.calculator.Group;
import com.ovopark.check.core.calculator.InspectionRecord;
import com.ovopark.check.core.calculator.rule.Rule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;

public class Action
implements Comparable<Action> {
    private Integer matchCount;
    private Double redudence;
    private Double upperLimit;
    private Integer timesType = 0;
    private Integer type;
    private final List<BiConsumer<Group, Double>> functions = Arrays.asList(this::normal, this::groupZero, this::finalZero, this::zeroThenSubGroupUntilZero, this::zeroThenSubFinalUntilZero, this::subGroupUntilZero, this::subFinalUntilZero, this::allowEdit, this::allowEdit, this::allowEdit, this::allowEdit);

    public Action(Integer matchCount, Double redudence, Integer type, Integer timesType, Double upperLimit) {
        this.matchCount = matchCount;
        this.redudence = redudence;
        this.type = type;
        this.timesType = timesType;
        this.upperLimit = upperLimit;
    }

    public void accept(Group group, List<InspectionRecord> records) {
        if (this.redudence == null && !group.getCustomScoreCalculator().isAddModel() && records.size() == 1) {
            Double r = records.get(0).getRedudence();
            if (r == null) {
                r = 0.0;
            }
            this.functions.get(this.type).accept(group, r);
        } else {
            this.functions.get(this.type).accept(group, this.redudence);
        }
    }

    public void accept(CustomScoreCalculator calculator, Map<Integer, Integer> groupWeight) {
        int allCount = groupWeight.values().stream().mapToInt(Integer::intValue).sum();
        Optional<Double> single = Optional.ofNullable(this.redudence).map(r -> r / (double)allCount);
        groupWeight.forEach((k, v) -> {
            Group group = new Group((Integer)k, (List<Rule>)new ArrayList<Rule>(), null);
            group.setCustomScoreCalculator(calculator);
            this.functions.get(this.type).accept(group, single.map(s -> s * (double)v.intValue()).orElse(null));
        });
    }

    public void accept(Group group, InspectionRecord record) {
        if (Rule.isRepeatable(this.type) && record != null) {
            int times;
            int n = times = record.getTimes() == null ? 1 : record.getTimes();
            if (Objects.equals(1, this.timesType)) {
                times = CollectionUtil.isEmpty(record.getUnqualifiedSubItemIds()) ? 1 : record.getUnqualifiedSubItemIds().size();
                record.setTimes(times);
            }
            Double stdScore = record.getInspectionItem().getScore();
            if (this.redudence == null) {
                this.redudence = stdScore;
            }
            double totalRedudence = (double)times * this.redudence;
            if (this.upperLimit != null && this.upperLimit > 0.0) {
                totalRedudence = Math.min(this.upperLimit, totalRedudence);
            }
            double rd = stdScore - totalRedudence;
            record.setScore(Math.max(0.0, rd));
            rd = rd < 0.0 ? Math.abs(rd) : 0.0;
            this.functions.get(this.type).accept(group, rd);
            return;
        }
        this.functions.get(this.type).accept(group, this.redudence);
    }

    private void normal(Group group, Double score) {
    }

    private void groupZero(Group group, Double score) {
        group.setFinalZero(true);
    }

    private void finalZero(Group group, Double score) {
        FinalSideEffect finalSideEffect = new FinalSideEffect(group.getId(), (Double)Double.MAX_VALUE);
        group.getCustomScoreCalculator().addSideEffect(finalSideEffect);
    }

    private void zeroThenSubGroupUntilZero(Group group, Double score) {
        group.setRedudence(score + group.getRedudence());
    }

    private void zeroThenSubFinalUntilZero(Group group, Double score) {
        FinalSideEffect finalSideEffect = new FinalSideEffect(group.getId(), score);
        group.getCustomScoreCalculator().addSideEffect(finalSideEffect);
    }

    private void subGroupUntilZero(Group group, Double score) {
        group.setRedudence(score + group.getRedudence());
    }

    private void subFinalUntilZero(Group group, Double score) {
        FinalSideEffect finalSideEffect = new FinalSideEffect(group.getId(), score);
        group.getCustomScoreCalculator().addSideEffect(finalSideEffect);
    }

    private void allowEdit(Group group, Double score) {
    }

    @Override
    public int compareTo(Action o) {
        return this.matchCount.compareTo(o.matchCount);
    }

    public Integer getMatchCount() {
        return this.matchCount;
    }

    public Double getRedudence() {
        return this.redudence;
    }

    public Double getUpperLimit() {
        return this.upperLimit;
    }

    public Integer getTimesType() {
        return this.timesType;
    }

    public Integer getType() {
        return this.type;
    }

    public List<BiConsumer<Group, Double>> getFunctions() {
        return this.functions;
    }

    public void setMatchCount(Integer matchCount) {
        this.matchCount = matchCount;
    }

    public void setRedudence(Double redudence) {
        this.redudence = redudence;
    }

    public void setUpperLimit(Double upperLimit) {
        this.upperLimit = upperLimit;
    }

    public void setTimesType(Integer timesType) {
        this.timesType = timesType;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Action)) {
            return false;
        }
        Action other = (Action)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$matchCount = this.getMatchCount();
        Integer other$matchCount = other.getMatchCount();
        if (this$matchCount == null ? other$matchCount != null : !((Object)this$matchCount).equals(other$matchCount)) {
            return false;
        }
        Double this$redudence = this.getRedudence();
        Double other$redudence = other.getRedudence();
        if (this$redudence == null ? other$redudence != null : !((Object)this$redudence).equals(other$redudence)) {
            return false;
        }
        Double this$upperLimit = this.getUpperLimit();
        Double other$upperLimit = other.getUpperLimit();
        if (this$upperLimit == null ? other$upperLimit != null : !((Object)this$upperLimit).equals(other$upperLimit)) {
            return false;
        }
        Integer this$timesType = this.getTimesType();
        Integer other$timesType = other.getTimesType();
        if (this$timesType == null ? other$timesType != null : !((Object)this$timesType).equals(other$timesType)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        List<BiConsumer<Group, Double>> this$functions = this.getFunctions();
        List<BiConsumer<Group, Double>> other$functions = other.getFunctions();
        return !(this$functions == null ? other$functions != null : !((Object)this$functions).equals(other$functions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Action;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $matchCount = this.getMatchCount();
        result = result * 59 + ($matchCount == null ? 43 : ((Object)$matchCount).hashCode());
        Double $redudence = this.getRedudence();
        result = result * 59 + ($redudence == null ? 43 : ((Object)$redudence).hashCode());
        Double $upperLimit = this.getUpperLimit();
        result = result * 59 + ($upperLimit == null ? 43 : ((Object)$upperLimit).hashCode());
        Integer $timesType = this.getTimesType();
        result = result * 59 + ($timesType == null ? 43 : ((Object)$timesType).hashCode());
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        List<BiConsumer<Group, Double>> $functions = this.getFunctions();
        result = result * 59 + ($functions == null ? 43 : ((Object)$functions).hashCode());
        return result;
    }

    public String toString() {
        return "Action(matchCount=" + this.getMatchCount() + ", redudence=" + this.getRedudence() + ", upperLimit=" + this.getUpperLimit() + ", timesType=" + this.getTimesType() + ", type=" + this.getType() + ", functions=" + this.getFunctions() + ")";
    }
}

