/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.check.core.review;

import com.ovopark.check.core.review.ReviewNode;
import com.ovopark.check.support.User;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class ReviewChain {
    private Integer id;
    private final ReviewNode reviewNode;
    private final Integer curLevel;
    private Integer allowRefuse;

    public ReviewChain(ReviewNode reviewNode, Integer curLevel) {
        this.reviewNode = reviewNode;
        this.curLevel = curLevel;
    }

    public ReviewChain(Integer id, ReviewNode reviewNode, Integer curLevel) {
        this.id = id;
        this.reviewNode = reviewNode;
        this.curLevel = curLevel;
    }

    public ReviewChain(ReviewNode reviewNode, Integer curLevel, Integer allowRefuse) {
        this.reviewNode = reviewNode;
        this.curLevel = curLevel;
        this.allowRefuse = allowRefuse;
    }

    public ReviewNode lookupNextReviewNode() {
        if (this.reviewNode == null) {
            return null;
        }
        ReviewNode next = this.reviewNode;
        if (this.curLevel != null) {
            int i = 0;
            while (i++ <= this.curLevel) {
                if (next == null) {
                    return null;
                }
                next = next.next();
            }
        }
        while (next != null) {
            if (next.match()) {
                if (this.curLevel == null && next.needSpecifyReviewer() || !next.needSpecifyReviewer() && CollectionUtils.isEmpty(next.getUsers())) {
                    next = next.next();
                    continue;
                }
                return next;
            }
            next = next.next();
        }
        return null;
    }

    public List<Integer> allReviewerId() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (ReviewNode next = this.reviewNode; next != null; next = next.next()) {
            if (CollectionUtils.isEmpty(next.getUsers())) continue;
            ids.addAll(next.getUsers().stream().map(User::getId).collect(Collectors.toList()));
        }
        return ids;
    }

    public List<ReviewNode> undoneReviewNodes() {
        ReviewNode next;
        ArrayList<ReviewNode> nodes = new ArrayList<ReviewNode>();
        for (next = this.reviewNode; next != null && this.curLevel != null; next = next.next()) {
            if (!Objects.equals(next.getLevel(), this.curLevel)) continue;
            nodes.add(next);
            break;
        }
        next = this.lookupNextReviewNode();
        while (next != null) {
            if (next.match()) {
                nodes.add(next);
            }
            next = next.next();
        }
        return nodes;
    }

    public String prettyString() {
        ArrayList<String> desc = new ArrayList<String>();
        for (ReviewNode node = this.reviewNode; node != null; node = node.next()) {
            desc.add(node.prettyString());
        }
        return desc.stream().collect(Collectors.joining("\n      \u2193\n")) + "\n\n\u4e0b\u4e00\u7ea7\n" + Optional.ofNullable(this.lookupNextReviewNode()).map(ReviewNode::prettyString).orElse("\u65e0");
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getCurLevel() {
        return this.curLevel;
    }

    public Integer getAllowRefuse() {
        return this.allowRefuse;
    }
}

