/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.check.support;

import cn.hutool.core.date.DateUtil;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public class User
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer id;
    private String accountName;
    private String name;
    private String localeIndex;
    private Integer groupId;
    private Integer isAgency;
    private String timeZone;
    private String lang;
    private String token;
    private String thumbUrl;
    private String mobilePhone;
    private Boolean frozen;

    public Locale getLocale() {
        if ("ENGLISH".equalsIgnoreCase(this.localeIndex)) {
            return Locale.US;
        }
        if ("TRADITIONAL_CHINESE".equalsIgnoreCase(this.localeIndex)) {
            return Locale.TRADITIONAL_CHINESE;
        }
        if ("INDONESIA".equalsIgnoreCase(this.localeIndex)) {
            return new Locale("in", "ID");
        }
        return Locale.SIMPLIFIED_CHINESE;
    }

    public String localNowTimeString() {
        if (StringUtils.isBlank((CharSequence)this.timeZone)) {
            this.timeZone = "GMT+8:00";
        }
        TimeZone timeZone = TimeZone.getTimeZone(this.timeZone);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        simpleDateFormat.setTimeZone(timeZone);
        simpleDateFormat.applyPattern("yyyy-MM-dd HH:mm:ss");
        return simpleDateFormat.format(new Date());
    }

    public Date localNowDate() {
        return DateUtil.parse((CharSequence)this.localNowTimeString(), (String)"yyyy-MM-dd HH:mm:ss").toJdkDate();
    }

    public Integer getId() {
        return this.id;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getName() {
        return this.name;
    }

    public String getLocaleIndex() {
        return this.localeIndex;
    }

    public Integer getGroupId() {
        return this.groupId;
    }

    public Integer getIsAgency() {
        return this.isAgency;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public String getLang() {
        return this.lang;
    }

    public String getToken() {
        return this.token;
    }

    public String getThumbUrl() {
        return this.thumbUrl;
    }

    public String getMobilePhone() {
        return this.mobilePhone;
    }

    public Boolean getFrozen() {
        return this.frozen;
    }

    public User setId(Integer id) {
        this.id = id;
        return this;
    }

    public User setAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    public User setName(String name) {
        this.name = name;
        return this;
    }

    public User setLocaleIndex(String localeIndex) {
        this.localeIndex = localeIndex;
        return this;
    }

    public User setGroupId(Integer groupId) {
        this.groupId = groupId;
        return this;
    }

    public User setIsAgency(Integer isAgency) {
        this.isAgency = isAgency;
        return this;
    }

    public User setTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public User setLang(String lang) {
        this.lang = lang;
        return this;
    }

    public User setToken(String token) {
        this.token = token;
        return this;
    }

    public User setThumbUrl(String thumbUrl) {
        this.thumbUrl = thumbUrl;
        return this;
    }

    public User setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
        return this;
    }

    public User setFrozen(Boolean frozen) {
        this.frozen = frozen;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$accountName = this.getAccountName();
        String other$accountName = other.getAccountName();
        if (this$accountName == null ? other$accountName != null : !this$accountName.equals(other$accountName)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$localeIndex = this.getLocaleIndex();
        String other$localeIndex = other.getLocaleIndex();
        if (this$localeIndex == null ? other$localeIndex != null : !this$localeIndex.equals(other$localeIndex)) {
            return false;
        }
        Integer this$groupId = this.getGroupId();
        Integer other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !((Object)this$groupId).equals(other$groupId)) {
            return false;
        }
        Integer this$isAgency = this.getIsAgency();
        Integer other$isAgency = other.getIsAgency();
        if (this$isAgency == null ? other$isAgency != null : !((Object)this$isAgency).equals(other$isAgency)) {
            return false;
        }
        String this$timeZone = this.getTimeZone();
        String other$timeZone = other.getTimeZone();
        if (this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone)) {
            return false;
        }
        String this$lang = this.getLang();
        String other$lang = other.getLang();
        if (this$lang == null ? other$lang != null : !this$lang.equals(other$lang)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$thumbUrl = this.getThumbUrl();
        String other$thumbUrl = other.getThumbUrl();
        if (this$thumbUrl == null ? other$thumbUrl != null : !this$thumbUrl.equals(other$thumbUrl)) {
            return false;
        }
        String this$mobilePhone = this.getMobilePhone();
        String other$mobilePhone = other.getMobilePhone();
        if (this$mobilePhone == null ? other$mobilePhone != null : !this$mobilePhone.equals(other$mobilePhone)) {
            return false;
        }
        Boolean this$frozen = this.getFrozen();
        Boolean other$frozen = other.getFrozen();
        return !(this$frozen == null ? other$frozen != null : !((Object)this$frozen).equals(other$frozen));
    }

    protected boolean canEqual(Object other) {
        return other instanceof User;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $accountName = this.getAccountName();
        result = result * 59 + ($accountName == null ? 43 : $accountName.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $localeIndex = this.getLocaleIndex();
        result = result * 59 + ($localeIndex == null ? 43 : $localeIndex.hashCode());
        Integer $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : ((Object)$groupId).hashCode());
        Integer $isAgency = this.getIsAgency();
        result = result * 59 + ($isAgency == null ? 43 : ((Object)$isAgency).hashCode());
        String $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : $timeZone.hashCode());
        String $lang = this.getLang();
        result = result * 59 + ($lang == null ? 43 : $lang.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $thumbUrl = this.getThumbUrl();
        result = result * 59 + ($thumbUrl == null ? 43 : $thumbUrl.hashCode());
        String $mobilePhone = this.getMobilePhone();
        result = result * 59 + ($mobilePhone == null ? 43 : $mobilePhone.hashCode());
        Boolean $frozen = this.getFrozen();
        result = result * 59 + ($frozen == null ? 43 : ((Object)$frozen).hashCode());
        return result;
    }

    public String toString() {
        return "User(id=" + this.getId() + ", accountName=" + this.getAccountName() + ", name=" + this.getName() + ", localeIndex=" + this.getLocaleIndex() + ", groupId=" + this.getGroupId() + ", isAgency=" + this.getIsAgency() + ", timeZone=" + this.getTimeZone() + ", lang=" + this.getLang() + ", token=" + this.getToken() + ", thumbUrl=" + this.getThumbUrl() + ", mobilePhone=" + this.getMobilePhone() + ", frozen=" + this.getFrozen() + ")";
    }
}

