/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.check.core;

import com.ovopark.check.core.CheckTask;
import com.ovopark.check.core.CheckTaskRecord;
import com.ovopark.check.core.CheckTemplateRewardConfig;
import com.ovopark.check.core.InspectionItem;
import com.ovopark.check.core.ScoreValue;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class CheckTemplateRewardRule
implements Serializable {
    private List<CheckTemplateRewardConfig> configs;
    private List<InspectionItem> veto;

    public boolean shouldReward(CheckTask checkTask) {
        if (CollectionUtils.isEmpty(this.veto)) {
            return true;
        }
        List unqualifiedRecords = checkTask.getRecords().stream().filter(CheckTaskRecord::isUnqualified).map(CheckTaskRecord::getInspectionItem).map(InspectionItem::getId).collect(Collectors.toList());
        List vetoIds = this.veto.stream().map(InspectionItem::getId).collect(Collectors.toList());
        return unqualifiedRecords.stream().noneMatch(vetoIds::contains);
    }

    public double calRewardMondy(ScoreValue score) {
        if (CollectionUtils.isEmpty(this.configs)) {
            return 0.0;
        }
        return this.configs.stream().filter(e -> e.match(score)).findFirst().map(CheckTemplateRewardConfig::getMoney).orElse(0.0);
    }

    public List<CheckTemplateRewardConfig> getConfigs() {
        return this.configs;
    }

    public List<InspectionItem> getVeto() {
        return this.veto;
    }

    public void setConfigs(List<CheckTemplateRewardConfig> configs) {
        this.configs = configs;
    }

    public void setVeto(List<InspectionItem> veto) {
        this.veto = veto;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CheckTemplateRewardRule)) {
            return false;
        }
        CheckTemplateRewardRule other = (CheckTemplateRewardRule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<CheckTemplateRewardConfig> this$configs = this.getConfigs();
        List<CheckTemplateRewardConfig> other$configs = other.getConfigs();
        if (this$configs == null ? other$configs != null : !((Object)this$configs).equals(other$configs)) {
            return false;
        }
        List<InspectionItem> this$veto = this.getVeto();
        List<InspectionItem> other$veto = other.getVeto();
        return !(this$veto == null ? other$veto != null : !((Object)this$veto).equals(other$veto));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CheckTemplateRewardRule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<CheckTemplateRewardConfig> $configs = this.getConfigs();
        result = result * 59 + ($configs == null ? 43 : ((Object)$configs).hashCode());
        List<InspectionItem> $veto = this.getVeto();
        result = result * 59 + ($veto == null ? 43 : ((Object)$veto).hashCode());
        return result;
    }

    public String toString() {
        return "CheckTemplateRewardRule(configs=" + this.getConfigs() + ", veto=" + this.getVeto() + ")";
    }
}

