/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.check.core;

import com.ovopark.check.core.ScoreValue;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Score {
    private Integer id;
    private Double totalScore = 0.0;
    private Double score = 0.0;
    private Double returnScore;
    private Double redudenceScore;
    private Double rewardScore;
    private Double sketchyScore;
    @Deprecated
    private Double showScore;
    @Deprecated
    private Double showReturnScore;
    private Double percentScore;
    private Double percentReturnScore;
    @Deprecated
    private String scoreLabel;
    private List<Score> children;
    private Level level = Level.TASK;

    public Score() {
        this.children = new ArrayList<Score>();
    }

    public Double getPercentScore() {
        if (this.totalScore == null || this.score == null || this.totalScore <= 0.0) {
            return 0.0;
        }
        return BigDecimal.valueOf(this.getShowScore()).setScale(2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).divide(BigDecimal.valueOf(this.totalScore), 2, RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    public Double getPercentReturnScore() {
        if (this.totalScore == null || this.returnScore == null || this.totalScore <= 0.0) {
            return 0.0;
        }
        return BigDecimal.valueOf(this.getShowReturnScore()).setScale(2, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L)).divide(BigDecimal.valueOf(this.totalScore), 2, RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    private void setShowScore(Double showScore) {
        throw new IllegalStateException("showScore is deprecated");
    }

    private void setShowReturnScore(Double showScore) {
        throw new IllegalStateException("showReturnScore is deprecated");
    }

    public Double getShowScore() {
        return this.getScore();
    }

    public Double getShowReturnScore() {
        return this.getReturnScore();
    }

    public String getScoreLabel() {
        if (this.totalScore <= 0.0) {
            return "0/0";
        }
        return this.getShowScore() + "/" + this.getTotalScore();
    }

    public Double getScore() {
        return BigDecimal.valueOf(this.score).setScale(1, RoundingMode.HALF_UP).doubleValue();
    }

    public Double getReturnScore() {
        return BigDecimal.valueOf(this.returnScore).setScale(1, RoundingMode.HALF_UP).doubleValue();
    }

    public Double getTotalScore() {
        return BigDecimal.valueOf(this.totalScore).setScale(1, RoundingMode.HALF_UP).doubleValue();
    }

    public Double getRedudenceScore() {
        return ScoreValue.of(this.redudenceScore).doubleValue(1);
    }

    public Double getOriginTotalScore() {
        return this.totalScore;
    }

    public Score getScore(Integer id, Level level) {
        if (this.level == level) {
            return this;
        }
        for (Score child : this.getChildren()) {
            if (child.level == level && Objects.equals(id, child.getId())) {
                return child;
            }
            for (Score childChild : child.getChildren()) {
                if (childChild.level != level || !Objects.equals(id, childChild.getId())) continue;
                return childChild;
            }
        }
        throw new RuntimeException("i18n.no.corresponding.score.found");
    }

    public Integer getId() {
        return this.id;
    }

    public Double getRewardScore() {
        return this.rewardScore;
    }

    public Double getSketchyScore() {
        return this.sketchyScore;
    }

    public List<Score> getChildren() {
        return this.children;
    }

    public Level getLevel() {
        return this.level;
    }

    public Score setId(Integer id) {
        this.id = id;
        return this;
    }

    public Score setTotalScore(Double totalScore) {
        this.totalScore = totalScore;
        return this;
    }

    public Score setScore(Double score) {
        this.score = score;
        return this;
    }

    public Score setReturnScore(Double returnScore) {
        this.returnScore = returnScore;
        return this;
    }

    public Score setRedudenceScore(Double redudenceScore) {
        this.redudenceScore = redudenceScore;
        return this;
    }

    public Score setRewardScore(Double rewardScore) {
        this.rewardScore = rewardScore;
        return this;
    }

    public Score setSketchyScore(Double sketchyScore) {
        this.sketchyScore = sketchyScore;
        return this;
    }

    public Score setPercentScore(Double percentScore) {
        this.percentScore = percentScore;
        return this;
    }

    public Score setPercentReturnScore(Double percentReturnScore) {
        this.percentReturnScore = percentReturnScore;
        return this;
    }

    @Deprecated
    public Score setScoreLabel(String scoreLabel) {
        this.scoreLabel = scoreLabel;
        return this;
    }

    public Score setChildren(List<Score> children) {
        this.children = children;
        return this;
    }

    public Score setLevel(Level level) {
        this.level = level;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Score)) {
            return false;
        }
        Score other = (Score)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Double this$totalScore = this.getTotalScore();
        Double other$totalScore = other.getTotalScore();
        if (this$totalScore == null ? other$totalScore != null : !((Object)this$totalScore).equals(other$totalScore)) {
            return false;
        }
        Double this$score = this.getScore();
        Double other$score = other.getScore();
        if (this$score == null ? other$score != null : !((Object)this$score).equals(other$score)) {
            return false;
        }
        Double this$returnScore = this.getReturnScore();
        Double other$returnScore = other.getReturnScore();
        if (this$returnScore == null ? other$returnScore != null : !((Object)this$returnScore).equals(other$returnScore)) {
            return false;
        }
        Double this$redudenceScore = this.getRedudenceScore();
        Double other$redudenceScore = other.getRedudenceScore();
        if (this$redudenceScore == null ? other$redudenceScore != null : !((Object)this$redudenceScore).equals(other$redudenceScore)) {
            return false;
        }
        Double this$rewardScore = this.getRewardScore();
        Double other$rewardScore = other.getRewardScore();
        if (this$rewardScore == null ? other$rewardScore != null : !((Object)this$rewardScore).equals(other$rewardScore)) {
            return false;
        }
        Double this$sketchyScore = this.getSketchyScore();
        Double other$sketchyScore = other.getSketchyScore();
        if (this$sketchyScore == null ? other$sketchyScore != null : !((Object)this$sketchyScore).equals(other$sketchyScore)) {
            return false;
        }
        Double this$showScore = this.getShowScore();
        Double other$showScore = other.getShowScore();
        if (this$showScore == null ? other$showScore != null : !((Object)this$showScore).equals(other$showScore)) {
            return false;
        }
        Double this$showReturnScore = this.getShowReturnScore();
        Double other$showReturnScore = other.getShowReturnScore();
        if (this$showReturnScore == null ? other$showReturnScore != null : !((Object)this$showReturnScore).equals(other$showReturnScore)) {
            return false;
        }
        Double this$percentScore = this.getPercentScore();
        Double other$percentScore = other.getPercentScore();
        if (this$percentScore == null ? other$percentScore != null : !((Object)this$percentScore).equals(other$percentScore)) {
            return false;
        }
        Double this$percentReturnScore = this.getPercentReturnScore();
        Double other$percentReturnScore = other.getPercentReturnScore();
        if (this$percentReturnScore == null ? other$percentReturnScore != null : !((Object)this$percentReturnScore).equals(other$percentReturnScore)) {
            return false;
        }
        String this$scoreLabel = this.getScoreLabel();
        String other$scoreLabel = other.getScoreLabel();
        if (this$scoreLabel == null ? other$scoreLabel != null : !this$scoreLabel.equals(other$scoreLabel)) {
            return false;
        }
        List<Score> this$children = this.getChildren();
        List<Score> other$children = other.getChildren();
        if (this$children == null ? other$children != null : !((Object)this$children).equals(other$children)) {
            return false;
        }
        Level this$level = this.getLevel();
        Level other$level = other.getLevel();
        return !(this$level == null ? other$level != null : !((Object)((Object)this$level)).equals((Object)other$level));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Score;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Double $totalScore = this.getTotalScore();
        result = result * 59 + ($totalScore == null ? 43 : ((Object)$totalScore).hashCode());
        Double $score = this.getScore();
        result = result * 59 + ($score == null ? 43 : ((Object)$score).hashCode());
        Double $returnScore = this.getReturnScore();
        result = result * 59 + ($returnScore == null ? 43 : ((Object)$returnScore).hashCode());
        Double $redudenceScore = this.getRedudenceScore();
        result = result * 59 + ($redudenceScore == null ? 43 : ((Object)$redudenceScore).hashCode());
        Double $rewardScore = this.getRewardScore();
        result = result * 59 + ($rewardScore == null ? 43 : ((Object)$rewardScore).hashCode());
        Double $sketchyScore = this.getSketchyScore();
        result = result * 59 + ($sketchyScore == null ? 43 : ((Object)$sketchyScore).hashCode());
        Double $showScore = this.getShowScore();
        result = result * 59 + ($showScore == null ? 43 : ((Object)$showScore).hashCode());
        Double $showReturnScore = this.getShowReturnScore();
        result = result * 59 + ($showReturnScore == null ? 43 : ((Object)$showReturnScore).hashCode());
        Double $percentScore = this.getPercentScore();
        result = result * 59 + ($percentScore == null ? 43 : ((Object)$percentScore).hashCode());
        Double $percentReturnScore = this.getPercentReturnScore();
        result = result * 59 + ($percentReturnScore == null ? 43 : ((Object)$percentReturnScore).hashCode());
        String $scoreLabel = this.getScoreLabel();
        result = result * 59 + ($scoreLabel == null ? 43 : $scoreLabel.hashCode());
        List<Score> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        Level $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : ((Object)((Object)$level)).hashCode());
        return result;
    }

    public String toString() {
        return "Score(id=" + this.getId() + ", totalScore=" + this.getTotalScore() + ", score=" + this.getScore() + ", returnScore=" + this.getReturnScore() + ", redudenceScore=" + this.getRedudenceScore() + ", rewardScore=" + this.getRewardScore() + ", sketchyScore=" + this.getSketchyScore() + ", showScore=" + this.getShowScore() + ", showReturnScore=" + this.getShowReturnScore() + ", percentScore=" + this.getPercentScore() + ", percentReturnScore=" + this.getPercentReturnScore() + ", scoreLabel=" + this.getScoreLabel() + ", children=" + this.getChildren() + ", level=" + (Object)((Object)this.getLevel()) + ")";
    }

    public static enum Level {
        TASK,
        GROUP,
        INSP_ITEM;

    }
}

