/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.check.core.calculator;

import com.ovopark.check.core.Score;
import com.ovopark.check.core.calculator.CustomScoreCalculator;
import com.ovopark.check.core.calculator.InspectionRecord;
import com.ovopark.check.core.calculator.InspectionStatusEnum;
import com.ovopark.check.core.calculator.rule.Rule;
import java.util.List;
import java.util.Objects;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;

public class Group {
    private Integer id;
    private Double redudence = 0.0;
    private boolean finalZero = false;
    private final List<Rule> rules;
    private CustomScoreCalculator customScoreCalculator;
    private Double totalScore;
    private List<InspectionRecord> records;
    private Double rewardScore = 0.0;
    private Integer weight;

    public Group(Integer id, List<Rule> rules, Double totalScore, Integer weight) {
        this.id = id;
        this.rules = rules;
        this.totalScore = totalScore;
        this.weight = weight;
        for (Rule rule : rules) {
            rule.setGroup(this);
        }
    }

    public <T extends Rule> void addRules(List<T> rules) {
        this.rules.addAll(rules);
        for (Rule rule : rules) {
            rule.setGroup(this);
        }
    }

    public void matchAndSeparate(List<InspectionRecord> records) {
        this.records = records.stream().filter(e -> Objects.equals(this.id, e.getInspectionItem().getGroupId())).collect(Collectors.toList());
        for (Rule rule : this.rules) {
            rule.matchAndKeep(records);
        }
    }

    public Score getScore() {
        double actualWeight = 1.0;
        if (this.weight != null) {
            actualWeight = this.weight.doubleValue() / 100.0;
        }
        Score score = new Score();
        score.setLevel(Score.Level.GROUP);
        List<Score> inspectionScores = this.rules.stream().flatMap(e -> e.getScore().stream()).collect(Collectors.toList());
        score.setChildren(inspectionScores);
        List inspItemIds = this.records.stream().filter(e -> e.getStatus() == InspectionStatusEnum.INAPPLICABLE).map(e -> e.getInspectionItem().getId()).collect(Collectors.toList());
        double all = this.isAddModel() ? inspectionScores.stream().filter(e -> !inspItemIds.contains(e.getId())).mapToDouble(Score::getTotalScore).sum() : this.totalScore.doubleValue();
        score.setTotalScore(all * actualWeight);
        score.setSketchyScore(this.sumScore(this.records, InspectionRecord::getScore) * actualWeight);
        score.setId(this.id);
        if (this.finalZero) {
            score.setScore(0.0);
            score.setReturnScore(0.0);
            return score;
        }
        double get = this.isAddModel() ? inspectionScores.stream().mapToDouble(Score::getScore).sum() : this.totalScore.doubleValue();
        double getReturn = this.isAddModel() ? inspectionScores.stream().mapToDouble(Score::getReturnScore).sum() : this.totalScore.doubleValue();
        score.setScore(Math.max(0.0, get - this.redudence) * actualWeight);
        score.setReturnScore(Math.max(0.0, getReturn - this.redudence) * actualWeight);
        return score;
    }

    private Double sumScore(List<InspectionRecord> records, ToDoubleFunction<InspectionRecord> function) {
        return records.stream().filter(e -> e.getStatus() != InspectionStatusEnum.INAPPLICABLE).mapToDouble(function).sum();
    }

    public boolean isAddModel() {
        return this.customScoreCalculator.isAddModel();
    }

    public Integer getId() {
        return this.id;
    }

    public Double getRedudence() {
        return this.redudence;
    }

    public boolean isFinalZero() {
        return this.finalZero;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public CustomScoreCalculator getCustomScoreCalculator() {
        return this.customScoreCalculator;
    }

    public Double getTotalScore() {
        return this.totalScore;
    }

    public List<InspectionRecord> getRecords() {
        return this.records;
    }

    public Double getRewardScore() {
        return this.rewardScore;
    }

    public Integer getWeight() {
        return this.weight;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setRedudence(Double redudence) {
        this.redudence = redudence;
    }

    public void setFinalZero(boolean finalZero) {
        this.finalZero = finalZero;
    }

    public void setCustomScoreCalculator(CustomScoreCalculator customScoreCalculator) {
        this.customScoreCalculator = customScoreCalculator;
    }

    public void setTotalScore(Double totalScore) {
        this.totalScore = totalScore;
    }

    public void setRecords(List<InspectionRecord> records) {
        this.records = records;
    }

    public void setRewardScore(Double rewardScore) {
        this.rewardScore = rewardScore;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Group)) {
            return false;
        }
        Group other = (Group)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Double this$redudence = this.getRedudence();
        Double other$redudence = other.getRedudence();
        if (this$redudence == null ? other$redudence != null : !((Object)this$redudence).equals(other$redudence)) {
            return false;
        }
        if (this.isFinalZero() != other.isFinalZero()) {
            return false;
        }
        List<Rule> this$rules = this.getRules();
        List<Rule> other$rules = other.getRules();
        if (this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules)) {
            return false;
        }
        CustomScoreCalculator this$customScoreCalculator = this.getCustomScoreCalculator();
        CustomScoreCalculator other$customScoreCalculator = other.getCustomScoreCalculator();
        if (this$customScoreCalculator == null ? other$customScoreCalculator != null : !((Object)this$customScoreCalculator).equals(other$customScoreCalculator)) {
            return false;
        }
        Double this$totalScore = this.getTotalScore();
        Double other$totalScore = other.getTotalScore();
        if (this$totalScore == null ? other$totalScore != null : !((Object)this$totalScore).equals(other$totalScore)) {
            return false;
        }
        List<InspectionRecord> this$records = this.getRecords();
        List<InspectionRecord> other$records = other.getRecords();
        if (this$records == null ? other$records != null : !((Object)this$records).equals(other$records)) {
            return false;
        }
        Double this$rewardScore = this.getRewardScore();
        Double other$rewardScore = other.getRewardScore();
        if (this$rewardScore == null ? other$rewardScore != null : !((Object)this$rewardScore).equals(other$rewardScore)) {
            return false;
        }
        Integer this$weight = this.getWeight();
        Integer other$weight = other.getWeight();
        return !(this$weight == null ? other$weight != null : !((Object)this$weight).equals(other$weight));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Group;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Double $redudence = this.getRedudence();
        result = result * 59 + ($redudence == null ? 43 : ((Object)$redudence).hashCode());
        result = result * 59 + (this.isFinalZero() ? 79 : 97);
        List<Rule> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        CustomScoreCalculator $customScoreCalculator = this.getCustomScoreCalculator();
        result = result * 59 + ($customScoreCalculator == null ? 43 : ((Object)$customScoreCalculator).hashCode());
        Double $totalScore = this.getTotalScore();
        result = result * 59 + ($totalScore == null ? 43 : ((Object)$totalScore).hashCode());
        List<InspectionRecord> $records = this.getRecords();
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        Double $rewardScore = this.getRewardScore();
        result = result * 59 + ($rewardScore == null ? 43 : ((Object)$rewardScore).hashCode());
        Integer $weight = this.getWeight();
        result = result * 59 + ($weight == null ? 43 : ((Object)$weight).hashCode());
        return result;
    }

    public String toString() {
        return "Group(id=" + this.getId() + ", redudence=" + this.getRedudence() + ", finalZero=" + this.isFinalZero() + ", rules=" + this.getRules() + ", customScoreCalculator=" + this.getCustomScoreCalculator() + ", totalScore=" + this.getTotalScore() + ", records=" + this.getRecords() + ", rewardScore=" + this.getRewardScore() + ", weight=" + this.getWeight() + ")";
    }
}

