/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.check.core;

import com.ovopark.check.core.CooperateStatusEnum;
import com.ovopark.check.support.User;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class Cooperator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private User user;
    private CooperateStatusEnum status = CooperateStatusEnum.ING;
    private Set<Integer> touchedItemIds = new HashSet<Integer>();
    private Boolean touched = false;

    public String getUserName() {
        return Optional.ofNullable(this.user).map(User::getName).orElse(null);
    }

    public void touchItem(Integer id) {
        this.touchedItemIds.add(id);
        this.touched = true;
    }

    public User getUser() {
        return this.user;
    }

    public CooperateStatusEnum getStatus() {
        return this.status;
    }

    public Set<Integer> getTouchedItemIds() {
        return this.touchedItemIds;
    }

    public Boolean getTouched() {
        return this.touched;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setStatus(CooperateStatusEnum status) {
        this.status = status;
    }

    public void setTouchedItemIds(Set<Integer> touchedItemIds) {
        this.touchedItemIds = touchedItemIds;
    }

    public void setTouched(Boolean touched) {
        this.touched = touched;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cooperator)) {
            return false;
        }
        Cooperator other = (Cooperator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        CooperateStatusEnum this$status = this.getStatus();
        CooperateStatusEnum other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Set<Integer> this$touchedItemIds = this.getTouchedItemIds();
        Set<Integer> other$touchedItemIds = other.getTouchedItemIds();
        if (this$touchedItemIds == null ? other$touchedItemIds != null : !((Object)this$touchedItemIds).equals(other$touchedItemIds)) {
            return false;
        }
        Boolean this$touched = this.getTouched();
        Boolean other$touched = other.getTouched();
        return !(this$touched == null ? other$touched != null : !((Object)this$touched).equals(other$touched));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Cooperator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        CooperateStatusEnum $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Set<Integer> $touchedItemIds = this.getTouchedItemIds();
        result = result * 59 + ($touchedItemIds == null ? 43 : ((Object)$touchedItemIds).hashCode());
        Boolean $touched = this.getTouched();
        result = result * 59 + ($touched == null ? 43 : ((Object)$touched).hashCode());
        return result;
    }

    public String toString() {
        return "Cooperator(user=" + this.getUser() + ", status=" + this.getStatus() + ", touchedItemIds=" + this.getTouchedItemIds() + ", touched=" + this.getTouched() + ")";
    }
}

