/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.check.core.calculator;

import com.ovopark.check.core.Score;
import com.ovopark.check.core.calculator.Group;
import com.ovopark.check.core.calculator.InspectionRecord;
import com.ovopark.check.core.calculator.InspectionStatusEnum;
import com.ovopark.check.core.calculator.ScoreCalculator;
import java.util.List;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class SimpleScoreCalculator
extends ScoreCalculator {
    private final List<Group> groups;
    private List<InspectionRecord> records;

    public SimpleScoreCalculator(List<Group> groups) {
        this.groups = groups;
    }

    @Override
    public ScoreCalculator feed(List<InspectionRecord> records) {
        this.records = records;
        return this;
    }

    @Override
    public Score calculate(boolean verbose) {
        if (CollectionUtils.isEmpty(this.records)) {
            throw new IllegalStateException("Calculator: please call method ScoreCalculator#feed before cal");
        }
        Score score = new Score();
        List<Score> groupScoreList = this.records.stream().collect(Collectors.groupingBy(e -> e.getInspectionItem().getGroupId())).values().stream().map(list -> {
            Score s = new Score();
            s.setChildren(list.stream().map(is -> {
                Score sc = new Score();
                sc.setScore(is.getScore());
                sc.setReturnScore(is.getReturnScore());
                sc.setTotalScore(is.getTotalScore());
                sc.setId(is.getInspectionItem().getId());
                sc.setLevel(Score.Level.INSP_ITEM);
                return sc;
            }).collect(Collectors.toList()));
            s.setTotalScore(this.sumScore((List<InspectionRecord>)list, InspectionRecord::getTotalScore));
            s.setScore(this.sumScore((List<InspectionRecord>)list, InspectionRecord::getScore));
            s.setReturnScore(this.sumScore((List<InspectionRecord>)list, InspectionRecord::getReturnScore));
            s.setId(((InspectionRecord)list.get(0)).getInspectionItem().getGroupId());
            s.setLevel(Score.Level.GROUP);
            return s;
        }).collect(Collectors.toList());
        return score.setScore(Math.max(0.0, this.sumScore(this.records, InspectionRecord::getScore) - this.sumScore(this.records, InspectionRecord::getExtra))).setReturnScore(Math.max(0.0, this.sumScore(this.records, InspectionRecord::getReturnScore) - this.sumScore(this.records, InspectionRecord::getExtra))).setTotalScore(this.sumScore(this.records, InspectionRecord::getTotalScore)).setSketchyScore(this.sumScore(this.records, InspectionRecord::getScore)).setChildren(groupScoreList).setLevel(Score.Level.TASK);
    }

    private Double sumScore(List<InspectionRecord> records, ToDoubleFunction<InspectionRecord> function) {
        return records.stream().filter(e -> e.getStatus() != InspectionStatusEnum.INAPPLICABLE).mapToDouble(function).sum();
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public List<InspectionRecord> getRecords() {
        return this.records;
    }

    public void setRecords(List<InspectionRecord> records) {
        this.records = records;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleScoreCalculator)) {
            return false;
        }
        SimpleScoreCalculator other = (SimpleScoreCalculator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Group> this$groups = this.getGroups();
        List<Group> other$groups = other.getGroups();
        if (this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups)) {
            return false;
        }
        List<InspectionRecord> this$records = this.getRecords();
        List<InspectionRecord> other$records = other.getRecords();
        return !(this$records == null ? other$records != null : !((Object)this$records).equals(other$records));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SimpleScoreCalculator;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Group> $groups = this.getGroups();
        result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
        List<InspectionRecord> $records = this.getRecords();
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SimpleScoreCalculator(groups=" + this.getGroups() + ", records=" + this.getRecords() + ")";
    }
}

