/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.check.core;

import cn.hutool.core.collection.CollectionUtil;
import com.ovopark.check.core.CheckTask;
import com.ovopark.check.core.CooperateStatusEnum;
import com.ovopark.check.core.Cooperator;
import com.ovopark.check.support.User;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class CooperateManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private CheckTask task;
    private List<Cooperator> cooperators = new ArrayList<Cooperator>();
    private Boolean locked = false;

    public List<Cooperator> getCooperatorsIgnoreCreator() {
        return this.cooperators.stream().filter(c -> !Objects.equals(c.getUser().getId(), this.task.getCreator().getId())).filter(c -> !Objects.equals(c.getStatus(), CooperateStatusEnum.NOT_ACCEPT)).collect(Collectors.toList());
    }

    public List<Cooperator> getJoinedCooperators() {
        return this.cooperators.stream().filter(c -> !Objects.equals(c.getStatus(), CooperateStatusEnum.NOT_ACCEPT)).collect(Collectors.toList());
    }

    public void touchItem(User user, Integer id) {
        if (CollectionUtil.isEmpty(this.cooperators)) {
            return;
        }
        this.cooperators.stream().filter(cooperator -> Objects.equals(cooperator.getUser().getId(), user.getId())).findFirst().ifPresent(cooperator -> cooperator.touchItem(id));
    }

    public boolean userSubmmited(User user) {
        return this.getCooperatorsIgnoreCreator().stream().filter(e -> Objects.equals(e.getUser().getId(), user.getId())).anyMatch(e -> e.getStatus() == CooperateStatusEnum.SUBMITED);
    }

    public CheckTask getTask() {
        return this.task;
    }

    public List<Cooperator> getCooperators() {
        return this.cooperators;
    }

    public Boolean getLocked() {
        return this.locked;
    }

    public void setTask(CheckTask task) {
        this.task = task;
    }

    public void setCooperators(List<Cooperator> cooperators) {
        this.cooperators = cooperators;
    }

    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CooperateManager)) {
            return false;
        }
        CooperateManager other = (CooperateManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CheckTask this$task = this.getTask();
        CheckTask other$task = other.getTask();
        if (this$task == null ? other$task != null : !((Object)this$task).equals(other$task)) {
            return false;
        }
        List<Cooperator> this$cooperators = this.getCooperators();
        List<Cooperator> other$cooperators = other.getCooperators();
        if (this$cooperators == null ? other$cooperators != null : !((Object)this$cooperators).equals(other$cooperators)) {
            return false;
        }
        Boolean this$locked = this.getLocked();
        Boolean other$locked = other.getLocked();
        return !(this$locked == null ? other$locked != null : !((Object)this$locked).equals(other$locked));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CooperateManager;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CheckTask $task = this.getTask();
        result = result * 59 + ($task == null ? 43 : ((Object)$task).hashCode());
        List<Cooperator> $cooperators = this.getCooperators();
        result = result * 59 + ($cooperators == null ? 43 : ((Object)$cooperators).hashCode());
        Boolean $locked = this.getLocked();
        result = result * 59 + ($locked == null ? 43 : ((Object)$locked).hashCode());
        return result;
    }

    public String toString() {
        return "CooperateManager(task=" + this.getTask() + ", cooperators=" + this.getCooperators() + ", locked=" + this.getLocked() + ")";
    }
}

