/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.check.core.scoring;

import cn.hutool.core.util.StrUtil;
import com.ovopark.check.core.CheckTaskRecord;
import com.ovopark.check.core.CheckTaskRecordStatusEnum;
import com.ovopark.check.core.ScoreValue;
import com.ovopark.check.core.scoring.ScoringBlockCondition;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class PriorityBlockScoringCondition
extends ScoringBlockCondition {
    private final Integer unqualifiedItemNumThreshold;
    private final Integer itemPriority;
    private final CheckTaskRecordStatusEnum status = CheckTaskRecordStatusEnum.UNQUALIFIED;

    public PriorityBlockScoringCondition(List<CheckTaskRecord> records, Integer itemPriority, Integer unqualifiedItemNumThreshold) {
        super(records);
        this.unqualifiedItemNumThreshold = unqualifiedItemNumThreshold;
        this.itemPriority = itemPriority;
    }

    @Override
    public boolean match(Double score, Boolean isReturnScore) {
        long matchCount;
        List unqualifiedRecords = this.records.stream().filter(e -> e.getStatus() == this.status).collect(Collectors.toList());
        if (isReturnScore.booleanValue()) {
            unqualifiedRecords = unqualifiedRecords.stream().filter(e -> e.getReturnScore() == ScoreValue.ZERO).collect(Collectors.toList());
        }
        return (matchCount = unqualifiedRecords.stream().filter(e -> this.itemPriority == null || Objects.equals(this.itemPriority, 0) || Objects.equals(e.getInspectionItem().getPriority(), this.itemPriority)).count()) >= (long)this.unqualifiedItemNumThreshold.intValue();
    }

    @Override
    public String prettyString(Double score, Boolean isReturnScore) {
        List unqualifiedRecords = this.records.stream().filter(e -> e.getStatus() == this.status).collect(Collectors.toList());
        long matchCount = unqualifiedRecords.stream().filter(e -> this.itemPriority == null || Objects.equals(this.itemPriority, 0) || Objects.equals(e.getInspectionItem().getPriority(), this.itemPriority)).count();
        return StrUtil.format((CharSequence)"[rule-priority:{} rule-unqualifiedItemNumThreshold:{}, match-count{}, match-result:{}]", (Object[])new Object[]{this.itemPriority, this.unqualifiedItemNumThreshold, matchCount, this.match(score, isReturnScore)});
    }
}

