package com.ovopark.api;

import com.ovopark.check.R;
import com.ovopark.check.Vo.ChecktaskRecordVo;
import com.ovopark.pojo.BaseResult;
import com.ovopark.pojo.UserPojo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * @ClassName CheckTaskRecordApi
 * @Description 点检任务子记录api
 * @Author yangjie
 * @Date 2021/8/12 13:38
 */
@FeignClient(value = "shopweb-check")
public interface CheckTaskRecordApi {

    /**
     * 根据id获取记录
     * @param id
     * @return
     */
    @PostMapping("/shopweb-check/checkTaskRecord/findById")
    R<ChecktaskRecordVo> findById(@RequestParam(value = "id") Integer id);

    @PostMapping(value="/shopweb-check/live-check-temp-report-model/getUnFinishedCheckRecodeNum")
    BaseResult<Integer> getUnFinishedCheckRecodeNum(@RequestBody UserPojo user);
}