package com.ovopark.api;

import com.ovopark.check.R;
import com.ovopark.check.Vo.ProcessVo;
import com.ovopark.check.core.DelFlowCmd;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(value = "shopweb-check")
public interface FlowApi {


    @PostMapping("/shopweb-check/newProcess/saveOrUpdate")
    R<Long> saveOrUpdate(@RequestParam("cmdStr")String cmdStr,
                         @RequestParam("enterpriseId")Long enterpriseId,
                         @RequestParam("userId")Long userId);

    @PostMapping("/shopweb-check/newProcess/delete")
    R<Long> delete(@RequestBody DelFlowCmd cmd);

    @GetMapping("/shopweb-check/newProcess/list")
    R<List<ProcessVo>> list(@RequestParam("enterpriseId")  Long enterpriseId);

    @GetMapping("/shopweb-check/newProcess/get")
    R<ProcessVo> get(@RequestParam("id")  Long id);
}
