package com.ovopark.check.Vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;
import java.util.Date;

/**
 * @ClassName OperationalEventVo
 * @Description 运营事件表
 * @Author yangJie
 * @Date 2024/11/02 15:29
 */

@Data
public class OperationalEventVo {

    /**
     * 门店id
     */
    private Integer deptId;

    /**
     * 企业ID
     */
    private Integer enterpriseId;

    /**
     * 事件类型:@link EventTypeEnum
     */

    private Integer eventType;

    /**
     * 业务数据id
     */
    private Integer linkId;

    /**
     * 创建人id
     */
    private Integer creator;

    /**
     * 创建时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    public enum EventTypeEnum {
        SELF_CHECK(0, "门店自检"),
        REFORM(1, "门店整改"),
        REPORT(2, "门店报备"),
        BIRD(3, "小鸟探店"),
        OA(4, "提交OA任务");

        private final Integer code;
        private final String desc;

        EventTypeEnum(Integer code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public Integer getCode() {
            return code;
        }

        public String getDesc() {
            return desc;
        }
    }

}