package com.ovopark.check.problem;

import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

@Data
public class Option {

    //选择题类型:    0单选，1多选
    private Integer choiceQuestionType;
    // 总得分
    private BigDecimal mark;
    // 整改人 审批人 都可以编辑（前提是当前处理人）
    private boolean editable = false;
    //选择题列表
    private List<Subject> subject;




    public BigDecimal getMark() {
        if(CollectionUtils.isEmpty(subject)){
            return BigDecimal.ZERO;
        }
        List<String> selected = subject.stream().filter(Subject::isChoiceStatus).map(Subject::getChoiceQuestionMark).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(selected)){
            return BigDecimal.ZERO;
        }
        return selected.stream().map(BigDecimal::new).reduce(BigDecimal.ZERO, BigDecimal::add);
    }
}
