package com.ovopark.check.Vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;
import java.util.Date;

@Data
public class CaptureTaskVo {
    private Integer id;

    private Integer groupId;

    private Integer userId;

    private String name;

    /**
     * 频率 1:按天，2：按小时,-1:一次
     */
    private Integer frequency;

    private String cron;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    /**
     * 1:开启状态，0：关闭状态
     */
    private Integer isProcessing;

    private String preNos;

    private Integer totalPreset;

    private Integer error;

    private String depIds;

    private String presetNameIds;

    private String dailyStartTime;

    private String dailyEndTime;

    /**
     * 执行时间间隔，单位秒
     */
    private Integer intervalSeconds;

    private Integer isContainerTask;

    private Integer allDeps;

    /**
     * xxl_job_info ID
     */
    private Integer jobId;

    /**
     * 对应的时区，为空或者等于8，都为东八区
     */
    private Integer timeZone;

    /**
     * 转换为东八区的cron表达式
     */
    private String cronExecute;

    /**
     * 转换为东八区的开始时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTimeExecute;

    /**
     * 转换为东八区的结束时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTimeExecute;

    /**
     * 转换为东八区的一天的开始时间
     */
    private String dailyStartTimeExecute;

    /**
     * 转换为东八区的一天的结束时间
     */
    private String dailyEndTimeExecute;

    /**
     创建时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /**
     更新人
     */
    private Integer updatedBy;

    /**
     * 更新时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updatedTime;

    /**
     * 对应的gms任务id
     */
    private String gmsTaskId;
}
