package com.ovopark.check.problem;

import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

@Data
public class Option {

    //选择题类型:    0单选，1多选 2常规题
    private Integer choiceQuestionType;
    // 总得分 （常规提探店需要传）
    private BigDecimal mark;
    // 总标准分 （常规提探店需要传）
    private BigDecimal totalMark;
    // 选择题整改人 审批人 都可以编辑（前提是当前处理人）
    // 常规题  审批人 都可以编辑（前提是当前处理人）
    private boolean editable = false;
    //选择题列表
    private List<Subject> subject;

    public BigDecimal getMark() {
        // 常规题
        if(choiceQuestionType == 2) return mark;
        // 选择题
        if(CollectionUtils.isEmpty(subject))    return BigDecimal.ZERO;
        List<String> selected = subject.stream().filter(Subject::isChoiceStatus).map(Subject::getChoiceQuestionMark).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(selected))   return BigDecimal.ZERO;
        return selected.stream().map(BigDecimal::new).reduce(BigDecimal.ZERO, BigDecimal::add);
    }


    public BigDecimal getTotalMark() {
        // 常规题返回总标准分
        if(choiceQuestionType == 2) return totalMark;
        //单选题 分数最高那个选项才是总分，多选题 所有分数加起来才是总分
        if(CollectionUtils.isEmpty(subject))    return BigDecimal.ZERO;
        if(choiceQuestionType == 0){
            return subject.stream().map(Subject::getChoiceQuestionMark).map(BigDecimal::new).max(BigDecimal::compareTo).orElse(BigDecimal.ZERO);
        }else{
            return subject.stream().map(Subject::getChoiceQuestionMark).map(BigDecimal::new).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
    }

    public boolean isChoiceQuestion(){
        return choiceQuestionType == 0 || choiceQuestionType == 1;
    }

    public boolean isCommonQuestion(){
        return choiceQuestionType == 2;
    }
}
